/******************************************************************************
 * $Id: procfile.c,v 1.3 92/08/08 01:34:26 romel Exp Locker: romel $
 * Name:	ProcessCfile
 * Proj:	uustat
 * Desc:	Performs an action on a file according to the settings of the given
 *		flags.  Determines whether the file should be manipulated (killed
 *		or rejuvinated) or displayed and calls the appropriate routines.
 * Synop:	int ProcessCfile (char * system, char * file)
 * Entry:	system: the name of the romote system
 *		file: the path name of the control file
 * Exit:	0 if successful, any other value signifies an error.
 * Notes:	The Display() function returns 0 if successful and -1 thru -4 for
 *		error of various types but these values are not used.
 * $Log:	procfile.c,v $
 * Revision 1.3  92/08/08  01:34:26  romel
 * fixed wrong error message behavior with -n option
 * 
 * Revision 1.2  92/08/05  01:38:09  romel
 * minor changes
 * 
 * Revision 1.1  92/08/04  16:58:07  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include "uustat.h"



int ProcessCfile (system, uflags, file)
char * system;
char * file;
uuflags * uflags;
	{
	int ret = 0;
	
	/* if operation is kill or rejuvinate */
	if (uflags->fkill || uflags->frejuv)
		{
		/* check if this is the right job - if not, do nothing */
		if (IsFileJobID ( file, uflags->jobid))
			{
			/* indicate that the job matched */
			uflags->count++;
			
			/* make sure user has permission to manipulate the job */
			if (CheckPerms (file))
				{
				ret = PerformAction (system, file, uflags);
				/* return on error */
				if (ret)
					{
					return ret;
					}
				if (uflags->fdispl)	
					printf ("job: %s successfully %s.\n", GetJobId (file),
						(uflags->fkill?"killed":"rejuvinated"));
					
				} /* if */	
			else
				{
				if (uflags->fdispl)	
					printf ("not owner\n");	
				ret = -1;
				}
			} /* IsFileJobID  */
		} /* if (uflags->fkill ... */
	else 
		/* otherwise, it's a form of display */
		/* jobs are not counted here -- there's another level of logic
		   to determine whether a job is to be displayed (and counted)
		   inside Display ()) */
		{
		/*
		*	call Display to show the stats for the file.  If nodisplay
		*	is set, Display() will detect this and take appropriate
		*	action
		*/
		ret = Display (system, uflags, file);
		if (ret)
			{
			return ret;
			}
		} /* else */	
	return ret;	
	} /* ProcessCfile */
