/******************************************************************************
 * $Id: mkuupath.c,v 1.1 92/08/04 16:57:42 romel Exp Locker: romel $
 * Name:	makeuupath
 * Proj:	uustat
 * Desc:	Creates a pathname for a file related to a particular system.  The
 *		file is located in the spool directory for the given system.
 *		Therefore, the pathname is created by concatenating the constant
 *		SPOOLDIR, which is the path to the uucp spool directory, with the
 *		system name and the filename.
 * Synop:	char * makeuupath (char * str, char * system, char * filename)
 * Entry:	str: pointer to character array which will hold resulting pathname
 *		system: the name of the remote system
 *		filename: the name of the file
 * Exit:	str
 * Notes:	This function uses the constant SPOOLDIR to determine where the
 *		uucp spool directory is.  This is usually set to "/usr/spool/uucp"
 *		but can be changed.  The definition of SPOOLDIR is in uustat.h.
 * $Log:	mkuupath.c,v $
 * Revision 1.1  92/08/04  16:57:42  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <string.h>
#include "uustat.h"



char * makeuupath (str, system, filename)
char * str, * system, * filename;
	{
	strcpy (str, SPOOLDIR);
	strcat (str, "/");
	strcat (str, system);
	strcat (str, "/");
	strcat (str, filename);
	
	return str;
	} /* makeuupath */
