/******************************************************************************
 * $Id: isctrlfile.c,v 1.1 92/08/04 16:57:08 romel Exp Locker: romel $
 * Name:	IsCtrlFile
 * Proj:	uustat
 * Desc:	Determines if the given file is a uucp control file.  A uucp control
 *		file has a basename that begins with "C.".
 * Synop:	int IsCtrlFile (char * file)
 * Entry:	file: pointer to array containing the pathname of the file to check
 * Exit:	TRUE or FALSE
 * Notes:	None
 * $Log:	isctrlfile.c,v $
 * Revision 1.1  92/08/04  16:57:08  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include "uustat.h"


int IsCtrlFile (file)
char * file;
	{
	static char * prefix = "C.";
	char * base;

	base = basename (file);
	
	if (strncmp (prefix, base, 2))
		{ /* files do not match */
		return FALSE;
		}
	else
		{ /* files match -- valid control file */
		return TRUE;
		}
	} /* IsCtrlFile */
