/******************************************************************************
 * $Id: getuname.c,v 1.1 92/08/04 16:56:55 romel Exp Locker: romel $
 * Name:	GetUname
 * Proj:	uustat
 * Desc:	Determines the login name of the user.  If the user has
 *		issued an su command the name returned will be that of the
 *		new user.
 * Synop:	char * GetUname ();
 * Entry:	Nothing
 * Exit:	pointer to array containing name of the user
 * Notes:	This function is needed because the getlogin() function does not
 *		return the needed information.  It returns the name of user that
 *		originally logged in, not the current, effective user name.
 * $Log:	getuname.c,v $
 * Revision 1.1  92/08/04  16:56:55  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include <string.h>


#define LLEN 100
#define NAMLEN 25


char * GetUname ()
	{
	static char uname[NAMLEN+1];
	static char line[LLEN+1];
	char * s, * t;
	int uid;
	int length;
	FILE *fp;
	
	/* 
	* get the real uid -- effective uid will be root or uucp
	* this info is used to determine if user has permission to delete a
	* file, etc.
	*/
	uid = getuid ();

	/* get login name from /etc/passwd */
	fp = fopen ("/etc/passwd", "r");
	if (fp == NULL)
		return NULL;
		
	/* scan the system password file for a matching user id */	
	while (1)
		{
		if (fgets (line, LLEN, fp) == NULL)
			{
			fclose(fp);
			return NULL;
			}
			
		t = strchr (line, ':');	
		s = strchr (t+1, ':');

		if (uid == atoi (s+1))
			break;

		} /* for */
		
	/* calculate the length, up to a maximum length of NAMLEN */	
	length = t - line;	
	length = (length > NAMLEN)?NAMLEN:length;
	
	strncpy (uname, line, length);
	uname[length] = '\0';
	
	fclose (fp);
	return uname;
	} /* GetUname */


#ifdef TEST

main ()
	{
	printf ("login name: %s\n",GetUname());
	}
#endif	
