/******************************************************************************
 * $Id: getsystem.c,v 1.1 92/08/04 16:56:40 romel Exp Locker: romel $
 * Name:	GetSystem
 * Proj:	uustat
 * Desc:	Returns the next remote system name known to uucp
 * Synop:	char * GetSystem (void);
 * Entry:	Nothing
 * Exit:	pointer to array containing name of next remote system
 * Notes:	This function queries the L.sys file to determine which systems
 *		uucp knows.
 * $Log:	getsystem.c,v $
 * Revision 1.1  92/08/04  16:56:40  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include "uustat.h"

#define	LINELEN	511		/* maximum length of SYSTEMS entry */

char * GetSystem ()
	{
	static FILE * fp;
	static char line[LINELEN];

	/* open the systems file if it hasn't been yet */
	if (fp == NULL)
		{
		fp = fopen (SYSTEMS, "r");
		if (fp == NULL)
			return NULL;
		} /* if (fp == NULL) */	

	/*
	*	get the next system name from the systems file
	*	if the line starts with a '#', it is a comment
	*/
	*line = '#';
	while (*line == '#')
		{
		if ((fgets (line, LINELEN, fp)) == NULL)
			{ /* no more lines */
			fclose (fp);
			return NULL;
			}
		} /* while *line == '#' */	
		
	/* extract just the system name */	
	strtok (line, " \t");	

	/* return pointer to name */
	return line;
	} /* GetSystem */


#ifdef TEST
main ()
	{
	char * s;

	printf ("known systems: \n");
	while ((s = GetSystem ()) != NULL)
		printf ("system: %s\n",s);
	}
#endif	
