/******************************************************************************
 * $Id: getfage.c,v 1.1 92/08/05 16:59:47 romel Exp Locker: romel $
 * Name:	GetFileAge
 * Proj:	uustat
 * Desc:	Calculates the age of a file in days
 * Synop:	int GetFileAge (char *file)
 * Entry:	file: the name of the file
 * Exit:	the age of the file if successful, -1 if not.
 * Notes:	Age of the file is calculated by taking the difference between the
 *		current time and the mtime of the file.  This result is then divided
 *		by the number of seconds in 24 hours to get the number of days.
 * $Log:	getfage.c,v $
 * Revision 1.1  92/08/05  16:59:47  romel
 * Initial revision
 * 
 *****************************************************************************/

#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "uustat.h"


#define SECSPERDAY (60L*60L*24L)		/* number of seconds in one day */



int GetFileAge (file)
char * file;
	{
	struct stat st;
	time_t tm;

	if (stat (file, &st) == -1)
		return -1;

	tm = time(NULL);
	return ((tm - st.st_mtime)/SECSPERDAY);
	} /* GetFileAge */



#ifdef TEST_MAIN


main (argc, argv)
int argc;
char *argv[];
	{
	if (argc > 1)
		{
		argv++;
		printf ("age of %s: %d\n", *argv, GetFileAge (*argv));
		}
	else
		printf ("usage: getfage file\n");	
	}
	
#endif	
