/******************************************************************************
 * $Id: getclstat.c,v 1.1 92/08/05 16:59:20 romel Exp Locker: romel $
 * Name:	GetCurLogStatus
 * Proj:	uustat
 * Desc:	Retrieves the date and status message from a system's uucp log file
 * Synop:	int GetCurLogStatus (char *system, char *Msg, char *Date)
 * Entry:	system: the system name
 *		Msg: pointer to where the status message should be stored
 *		Date: pointer to where the log date should be stored
 * Exit:	0 if successful
 *		-1 if log file does not exist.
 *		-2 if log file could not be opened
 *		-3 if seek error
 * Notes:	Uses the constant LOGDIR, defined in uustat.h, to determine where
 *		the log files are kept.  Normally, this constant is set to
 *		"/usr/spool/uucp/.Log/uucico".
 * $Log:	getclstat.c,v $
 * Revision 1.1  92/08/05  16:59:20  romel
 * Initial revision
 * 
 *****************************************************************************/


#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include "uustat.h"




int GetCurLogStatus (system, Msg, Date)
char *system, *Msg, *Date;
	{
	FILE * fp;
	char s[256], t[256];
	char *end, *p, *tmp;
	struct stat st;

	/* build path to log file */
	strcpy (s, LOGDIR);
	strcat (s, "/");
	strcat (s, system);
	
	/* get file stats.  if file does not exist or has zero-length, return -1 */
	if ((stat (s, &st) == -1) || (st.st_size == 0))
		return -1;

		
	/* open the log file */
	fp = fopen (s, "r");
	if (fp == NULL)
		{
		return -2;
		}

	/* if file size is greater than 512 bytes, seek to 256 bytes 
	before end of file */
	if (st.st_size > 512)
		{
		if (fseek (fp, -256L, 2) == -1)		
			{
			return -3;
			}
		} /* if st.st_size > 512 */	

	/* read until EOF, saving the last line read */
	p = s;
	while (fgets (p, 255, fp) != NULL)
		{
		/* alternate buffers because when fgets reads EOF, it empties the
			buffer.  therefore, the other buffer will contain the last line
		*/
		p = (p==s)?t:s;
		}
	/* set p to point to the buffer that contains the last line */	
	p = (p==s)?t:s;
	tmp = (p==s)?s:t;		/* tmp is temporary buffer, set to other one */

	/* 
	*	retrieve the date and the status message from the last line
	*/
	/* get the date */
	strncpy (Date, p, 14);

	/* to find the status message, point to the 16th char in array and search
	for first space char.  The status message begins with the next char */
	p = p+15;
	p = strchr (p, ' ');
	strcpy (tmp, p);

	
	/* check for existence of a process id in the status message 
		(the process id is surrounded by brackets, '{' and '}') */
	if (((end = strchr (tmp, '{')) != NULL) && (strchr (tmp, '}') != NULL))
		{ /* process id found -- remove it by terminating the string at the
			first char of the process id */
		*end = '\0';

		/* change to upper case */
		strupr (tmp);
		}
	else
		{ /* process id not found -- uucp probably in the middle of 
			something */
		strcpy (tmp, " TALKING");	
		}	
		
	fclose (fp);
	strcpy (Msg, tmp);
	return 0;
	} /* GetCurLogStatus */



#ifdef TEST_MAIN

main ()
	{
	char s[256], t[256];
	
	if (GetCurLogStatus ("chinet", s, t))
		{
		puts ("error");
		exit (1);
		}
	printf ("date: %s, status: %s\n", t, s);
	}

#endif
