/******************************************************************************
 * $Id: fileid.c,v 1.1 92/08/04 16:54:42 romel Exp Locker: romel $
 * Name:	IsFileJobID
 * Proj:	uustat
 * Desc:	Determines if the given filename has the given jobid
 * Synop:	int IsFileJobID (char * filename, char * jobid);
 * Entry:	filename: pointer to a char array containing the filename
 *		jobid: the job id to compare to
 * Exit:	TRUE or FALSE
 * Notes:	None
 * $Log:	fileid.c,v $
 * Revision 1.1  92/08/04  16:54:42  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include <string.h>
#include "uustat.h"





int IsFileJobID (filename, jobid)
char * filename;
char * jobid;
	{
	char * s;

	/*
	*	convert the filename to a jobid
	*/
	s = GetJobId (filename);
	if (s == NULL)
		/* invalid file */
		return FALSE;
		
	/*
	*	compare the file with the jobid and return result
	*/
	
	/* compare the string lengths first */
	if (strlen (s) != strlen (jobid))
		return FALSE;
		
	/* compare the strings themselves */	
	if (strcmp (s, jobid))
		{ /* strings are different */
		return FALSE;
		} 
	else
		{ /* strings match */
		return TRUE;
		}	
	} /* IsFileJobID */


#ifdef TEST

main ()
	{
	printf ("result: %d\n", IsFileJobID("C.aalkd44", "aalkd44"));
	printf ("result: %d\n", IsFileJobID("aalkd44", "aalkd44"));
	printf ("result: %d\n", IsFileJobID("D.aalkd44", "aalkd44"));
	printf ("result: %d\n", IsFileJobID("C.aalkda4", "aalkd44"));
	printf ("result: %d\n", IsFileJobID("C.aalkd4", "aalkd44"));
	
	printf ("result: %d\n", IsFileJobID("/usr/spool/uucp/chinet/C.aalkd44", "aalkd44"));
	printf ("result: %d\n", IsFileJobID("/usr/spool/uucp/chinet/aalkd44", "aalkd44"));
	printf ("result: %d\n", IsFileJobID("/usr/spool/uucp/chinet/D.aalkd44", "aalkd44"));
	printf ("result: %d\n", IsFileJobID("/usr/spool/uucp/chinet/C.aalkda4", "aalkd44"));
	printf ("result: %d\n", IsFileJobID("/usr/spool/uucp/chinet/C.aalkd4", "aalkd44"));
	}

#endif
