/******************************************************************************
 * $Id: checkperm.c,v 1.1 92/08/04 16:53:37 romel Exp Locker: romel $
 * Name:	CheckPerms
 * Proj:	uustat
 * Desc:	Determines whether user has permission to perform a kill or rejuvinate
 *		on a job.  Only the owner or root have permission
 * Synop:	int CheckPerms (char * file)
 * Entry:	file: pointer to a char array containing the name of the control file
 * Exit:	Returns:
 *			0 - false, user does NOT have permission
 *			1 - true, user owns the file
 *			2 - true, user is uucp or root
 * Notes:	None
 * $Log:	checkperm.c,v $
 * Revision 1.1  92/08/04  16:53:37  romel
 * Initial revision
 * 
 *****************************************************************************/
#include <stdio.h>
#include <sys/stat.h>
#include "uustat.h"



int CheckPerms (file)
char * file;
	{
	FILE * fp;
	char * issuer;
	
	/* open the file */
	fp = fopen (file, "r");
	if (fp == NULL)
		return 0;			/* false */
		
	/* 
	   === get the issuer ===
	   normally, a false would be returned if GetSender returned NULL,
	   indicating it could not find the sender.  However, there is a
	   special case of a touch file existing, which has a length of zero.
	   In this case GetSender would fail, yet we want the program to
	   continue.  For these files, the user issuing the kill directive
	   must be root or the actual owner of the file as given by the stat()
	   function (this is most likely uucp).
	*/
	issuer = GetSender (fp);
	fclose (fp);	
	
	/*
	   check the issuer with the real uid of user
	   if issuer is same as user --> true (1)
	   if user is root --> true (2)
	   otherwise --> check if actual owner = user (in file permissions)
	   	if actual owner = user --> true (1)
	   	else --> false
	*/
	if ((!strcmp (issuer, GetUname())))
		return 1;			/* match - return true */
	else if (getuid() == 0)
		return 2;
	else
		{ /* last chance - check actual owner with stat() */
		  /* this is only for the cases where the file is 0 length and is
		     an extra check -- all the files in the uucp queues should be
		     owned by uucp
		  */
		struct stat s;
		if (stat (file, &s) == -1)
			return 0;			/* false */

		if (s.st_uid == getuid())
			return 1;			/* true */
		else	
			return 0;			/* false */
		}	
	} /* CheckPerms */
