/*
 *      XMOUSE.C
 *      Test xterm mouse report
 *      klin, Wed Apr 29 21:23:54 1992
 *
 *      Libs:   -lcurses (-ltermcap on BSD)
 *      Test:   Start xmouse in a xterm window. Move the mouse and press
 *              any button. The button and the mouse position should
 *              be displayed. Exit the test program with CR or any other
 *              control character.
 */

#include <stdio.h>
#include <signal.h>
#include <curses.h>

/*
 *      Signal handler for signals SIGINT and SIGQUIT
 */
onintr()
{
  mouse(0);                     /* Turn off MIT mouse report */
  echo();
  noraw();
  endwin();
  fflush(stdout);
  exit(0);

} /* onintr() */

/*
 *      Turn on/off MIT mouse report
 */
mouse(f)
  int f;
{
  if(f)
    printf("\033[?9h");         /* ON */
  else
    printf("\033[?9l");         /* OFF */
  fflush(stdout);

} /* mouse() */

/*
 *      Main routine
 */
main()
{
  int c, i;

  signal(SIGINT,  onintr);
  signal(SIGQUIT, onintr);

  initscr();
  noecho();
  raw();
  mouse(1);
  fflush(stdout);

  printf("\r\n\n\nMove the mouse and hit any button (Exit with CR)\r\n\n\n");
  fflush(stdout);

  do {
    for(i = 0; i < 6; i++) {
      c = getchar();
      if(c < '\033')            /* EOF */
	break;
      switch(i) {
	case 0:                 /* ESC */
	  printf("Leadin: %02x ", c); break;
	case 3:                 /* Mouse button */
	  printf("Button:%02x ", c - ' '); break;
	case 4:                 /* Mouse column */
	  printf("Column:%02d ", c - ' ' - 1); break;
	case 5:                 /* Mouse row */
	  printf("Line:%02d ", c - ' ' - 1); break;
	default:
	  printf("%c ", c);
      }
    }
    putchar('\r');
    putchar('\n');
    fflush(stdout);
  } while(c > '\033');

  onintr();                     /* Exit */

} /* main() */
