/*
 *      HELP.C
 *      UTREE help routines.
 *      3.01-um klin, Sat Apr 20 11:02:33 1991
 *      3.03-um klin, Sat Feb 15 18:34:27 1992, Minor changes
 *            c klin, Mon Mar 30 11:10:00 1992, Minor changes
 *            f klin, Wed Apr 29 08:52:26 1992, Use xterm mouse
 *      3.04-um klin, Sat May 23 17:03:59 1992, Pager added
 *
 *      Copyright (c) 1991/92 by Peter Klingebiel & UNIX Magazin Muenchen.
 *      For copying and distribution information see the file COPYRIGHT.
 */
#ifndef lint
static char sccsid[] = "@(#) utree 3.04-um (klin) May 23 1992 help.c";
#endif  /* !lint */

#include "defs.h"

/* ---- Local variables and definitions ------------------------------- */

LOCAL hlist *hroot = HNULL;     /* Root of help pages                   */
LOCAL char helpfile[NAMELEN];   /* Help file name                       */
LOCAL char *helpmenu = NULL;    /* Help menuline                        */
#ifdef  USEXTERMMOUSE
LOCAL char *helpmouse = NULL;   /* Mouse help menuline                  */
#endif  /* USEXTERMMOUSE */

#define LINELEN 128             /* Max line length for help pages       */

/* ---- Functions and procedures -------------------------------------- */

/*
 *      INTERNAL USED ROUTINES
 */

/* Insert a help page for topic s into help page list for file fp */
LOCAL VOID inserthelp(s, fp)
  register char *s;
  register FILE *fp;
{
  char buf[LINELEN];
  register hlist *hp, *np;
  register char *i, k;
  register long p;
  register int n;

  p = ftell(fp);                /* Get position of topic in help file */
  i = s;                        /* and menu line item */
  while(*s && !(*s == ' ' || *s == '\t' || *s == '\n'))
    ++s;
  *s = '\0';
  /* Count number of lines for this help page */
  for(n = 0; fgets(buf, sizeof(buf), fp); n++)
    if(buf[0] == '#' && buf[1] == '@')
      break;
  if(*i && p > 0 && n > 0) {    /* Get the hotkey for help menu topic */
    s = i;
    k = *i;
    while(*s) {
      if(*s >= 'A' && *s <= 'Z') {
	k = *s;
	break;
      }
      ++s;
    }
    /* Get space for help page, fill up data and insert into list */
    hp = (hlist *) ualloc(1, sizeof(hlist));
    (void) strncpy(HITEM(hp), i, ITEMLEN-1);
    HHKEY(hp) = isupper(k) ? tolower(k) : k;
    HSPOS(hp) = p;
    HNLIN(hp) = n;
    HNEXT(hp) = HNULL;
    if(hroot == HNULL)
      hroot = hp;
    else {
      for(np = hroot; HNEXT(np); np = HNEXT(np))
	;
      HNEXT(np) = hp;
    }
  }

} /* inserthelp() */

/* Show help page hp from help file fp */
LOCAL int showhelppage(hp, fp)
  register hlist *hp;
  register FILE *fp;
{
  char buf[LINELEN], el[INPLEN];
  register int c;
  int n;

  initpage();                   /* Build help page */
  n = 0;
  while(fgets(buf, sizeof(buf), fp) && n < HNLIN(hp)) {
    (void) putpage(0, "%s", buf);
    ++n;
  }
  (void) sprintf(el, "Help about %s (Line", HITEM(hp));
  c = pagemenu("HELP", el, (int *) 0, 0, 0);
  return(c >= RV_NUL ? RV_OK : c);

} /* showhelppage() */

/* Utree help pages are contained in a help file. Each help page is     */
/* enclosed in a pair of lines '#@item' and '#@' which signal start and */
/* end of the help page to topic 'item'. This item is also copied into  */
/* the help menuline and the first character or the first upper case    */
/* character from item if found is used as hot key for selecting the    */
/* help page to this topic. The initialization routine scans the help   */
/* file and builds up a list of available help pages from this file.    */
GLOBL VOID inithelp()
{
  char buf[NAMELEN];
  register FILE *fp;
  register hlist *hp;
  register int l, i;
#ifdef  USEXTERMMOUSE
  char mit[ITEMLEN+1];
  register int j, k;
#endif  /* USEXTERMMOUSE */

#ifdef  UTHELP
  if(startup(buf, UTHELP) && (fp = fopen(buf, "r"))) {
    (void) strcpy(helpfile, buf);
    /* First read help file and insert help pages into list */
    while(fgets(buf, sizeof(buf), fp))
      if(buf[0] == '#' && buf[1] == '@' && buf[2])
	inserthelp(&buf[2], fp);
    /* Second build from help items the help menu line */
    l = columns - 4;
    helpmenu = ualloc((unsigned) l, sizeof(char));
# ifdef USEXTERMMOUSE
    if(usemouse)
      helpmouse = ualloc((unsigned) l, sizeof(char));
# endif /* USEXTERMMOUSE */
    for(hp = hroot, i = 0; hp; hp = HNEXT(hp)) {
      i += strlen(HITEM(hp)) + 1;
      if(i >= l)
	break;
      (void) strcat(helpmenu, " ");
      (void) strcat(helpmenu, HITEM(hp));
# ifdef USEXTERMMOUSE
      if(usemouse) {
	k = strlen(HITEM(hp));
	for(j = 0; j < k; j++)
	  mit[j] = HHKEY(hp);
	mit[j] = '\0';
	(void) strcat(helpmouse, "?");
	(void) strcat(helpmouse, mit);
      }
# endif /* USEXTERMMOUSE */
    }
    (void) fclose(fp);
    if((i + 5) < l) {
      (void) strcat(helpmenu, " Quit");
# ifdef USEXTERMMOUSE
      if(usemouse)
	(void) strcat(helpmouse, "?qqqq");
# endif /* USEXTERMMOUSE */
    }
  }
#endif  /* UTHELP */

} /* inithelp() */

/* Display help menu and help pages */
GLOBL int showhelp(k)
  register int k;
{
  register FILE *fp;
  register hlist *hp;
  register int c;
#ifdef  USEXTERMMOUSE
  register int x;
#endif  /* USEXTERMMOUSE */

  who = "HELP";
  if(hroot == HNULL || !(fp = fopen(helpfile, "r"))) {
    puthelp("%s %s", who, hitkey);
    return(errequest("Help", "Not available"));
  }

  /* Help menu loop */
  do {
    if(k) {
      c = k;
      k = 0;
    }
    else {
      if( !keypressed()) {
	putmenu("HELP:", helpmenu);
	(void) putecho("Help about which topic:");
      }
#ifdef  USEXTERMMOUSE
      if(usemouse) {            /* Get and interprete character */
	cursorset(CF_VISIBLE);
	c = getkey();
	cursorset(CF_INVISIBLE);
	flushout();
	switch(c) {
	  case K_BRK:           /* Interrupt */
	  case K_CANC:
	    c = RV_INT;
	    break;
	  case K_SIZE:          /* Screen size changed */
	    c = RV_SIZ;
	    break;
	  case K_EOF:           /* EOF */
	    c = RV_END;
	    break;
	  case K_SEL:           /* CR or NL */
	  case ' ':
	    c = RV_NUL;
	    break;
	  case K_MOUSE:         /* Mouse event */
	    if(mouseb || mousey != helpline)
	      c = RV_NUL;
	    else {
	      x = mousex - 5;
	      if(x < (int) strlen(helpmouse))
		c = helpmouse[x];
	      else
		c = '?';
	    }
	    break;
	  default:              /* Return lower character */
	    if(c > 0xff)
	      c = '?';
	    else if(isupper(c))
	      c = tolower(c);
	    break;
	}
      }
      else
#endif  /* USEXTERMMOUSE */
      c = hitakey(NULL);
      if(c == 'q' || c <= RV_NUL)
	break;
    }
    for(hp = hroot; hp && HHKEY(hp) != c; hp = HNEXT(hp))
      ;
    if(hp == HNULL || fseek(fp, HSPOS(hp), 0))
      bell(VARSET(V_BL));
    else
      c = showhelppage(hp, fp);
    treeflag = fileflag = SF_FULL;
  } while(c != 'q' && c > RV_NUL);

  /* Close help file and return */
  (void) fclose(fp);
  if(c == 'q' || c < RV_NUL)
    return(c);
  return(putversion(echoline, "HELP: Done"));

} /* showhelp() */
