/****************************************************************/
/*								*/
/*	XChess V2.7: Archiv					*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "ch.h"			/* Def. des Schachspiels */

extern	void	exit();
extern	char	*malloc();
extern	char	*memcpy();
extern	void	free();

/****************************************************************/
/*	Spiel speichern						*/
/****************************************************************/
/*	Return: 1-alles ok,     0-Fehler			*/
/****************************************************************/

int	save_game(name)

char	name[];					/* Filename	*/
{
	FILE *fp;				/* Filepointer	*/
	char na[STRLEN];			/* effektiver Name	*/
	int  i;

	while(*name==' ')			/* Spaces loeschen	*/
		name++;

	strcpy(na,name);			/* Name aufbereiten	*/
	strcat(na,".ch");

	if((fp=fopen(na,"w"))==(FILE *)0)	/* eroeffnen	*/
		return(0);			/* Fehler	*/

	fwrite((char *)&spdat,sizeof(SPDAT),1,fp);	/* schreiben	*/
	for(i=0;i<spdat.zuege+1;i++)
		fwrite((char *)archiv[i],sizeof(ARCHIV),1,fp);
	fwrite((char *)&mode,sizeof(mode),1,fp);
	fwrite((char *)&stufe,sizeof(stufe),1,fp);
	fwrite((char *)&varianten,sizeof(varianten),1,fp);
	fwrite((char *)&zeit,sizeof(zeit),1,fp);
	fwrite((char *)&varprosek,sizeof(varprosek),1,fp);
	fwrite((char *)&compzuege,sizeof(compzuege),1,fp);

	fclose(fp);

	return(1);
}

/****************************************************************/
/*	Spiel laden						*/
/****************************************************************/
/*	Return: 1-alles ok,     0-Fehler			*/
/****************************************************************/

int	load_game(name)

char	name[];					/* Filename	*/
{
	FILE *fp;				/* Filepointer	*/
	char na[STRLEN];			/* effektiver Name	*/
	int  i;

	while(*name==' ')			/* Spaces loeschen	*/
		name++;

	strcpy(na,name);			/* Name aufbereiten	*/
	strcat(na,".ch");

	if((fp=fopen(na,"r"))==(FILE *)0)	/* eroeffnen	*/
		return(0);			/* Fehler	*/

	for(i=0;i<MAXSP;i++)			/* Speicher freigeben	*/
		if(archiv[i]!=(ARCHIV *)0)
		{
			free(archiv[i]);
			archiv[i]=(ARCHIV *)0;
		}

	fread((char *)&spdat,sizeof(SPDAT),1,fp);	/* lesen	*/
	for(i=0;i<spdat.zuege+1;i++)
	{
		archiv[i]=(ARCHIV *)malloc((unsigned)sizeof(ARCHIV));
		if(archiv[i]==(ARCHIV *)0)	/* Fataler Fehler	*/
			exit(1);

		fread((char *)archiv[i],sizeof(ARCHIV),1,fp);
	}
	fread((char *)&mode,sizeof(mode),1,fp);
	fread((char *)&stufe,sizeof(stufe),1,fp);
	fread((char *)&varianten,sizeof(varianten),1,fp);
	fread((char *)&zeit,sizeof(zeit),1,fp);
	fread((char *)&varprosek,sizeof(varprosek),1,fp);
	fread((char *)&compzuege,sizeof(compzuege),1,fp);

	fclose(fp);

	return(1);
}

/****************************************************************/
/*	Spieldaten laden					*/
/****************************************************************/
/*	Return: 1-alles ok,     0-Fehler			*/
/****************************************************************/

int	load_spdat(name,dat)

char	name[];					/* Filename		*/
SPDAT	*dat;					/* Spieldaten		*/
{
	FILE *fp;				/* Filepointer		*/
	char na[STRLEN];			/* effektiver Name	*/

	while(*name==' ')			/* Spaces loeschen	*/
		name++;

	strcpy(na,name);			/* Name aufbereiten	*/
	strcat(na,".ch");

	if((fp=fopen(na,"r"))==(FILE *)0)	/* eroeffnen	*/
		return(0);			/* Fehler	*/

	fread((char *)dat,sizeof(SPDAT),1,fp);	/* lesen	*/

	fclose(fp);

	return(1);
}

/****************************************************************/
/*	Spieldaten archivieren					*/
/****************************************************************/

void	archiviere(dat)

SPDAT	*dat;				/* Spieldaten		*/
{
	int nr;				/* Zugnummer		*/
	int i,j;
	BYTE fig1,fig2;

	nr=dat->zuege;			/* Zugnummer bestimmen	*/

	if(nr>=MAXSP)			/* Speicher voll ?	*/
		exit(1);		/* Fehler		*/

	if(archiv[nr]==(ARCHIV *)0)
	{
		archiv[nr]=(ARCHIV *)malloc((unsigned)sizeof(ARCHIV));
						/* Speicher holen	*/
		if(archiv[nr]==(ARCHIV *)0)	/* Fataler Fehler	*/
			exit(1);
	}

	memcpy((char *)archiv[nr]->brett,(char *)dat->brett,GROE);
					/* Spielfeld kopieren		*/

	archiv[nr]->farbe=dat->farbe;	/* sonstige Daten kopieren	*/
	archiv[nr]->wkpos=dat->wkpos;
	archiv[nr]->skpos=dat->skpos;
	archiv[nr]->lzug=dat->lzug;

	archiv[nr]->wdh= -1;		/* Keine Wiederholung		*/
	for(i=nr-1;i>=0;i--)		/* alle durchgehen		*/
	{
		for(j=0;j<GROE;j++)
		{
			fig1=archiv[nr]->brett[j];
			if(_istxtur(fig1))
				fig1=TUR | _farbe(fig1);
			if(_istxkoe(fig1))
				fig1=KOE | _farbe(fig1);

			fig2=archiv[i]->brett[j];
			if(_istxtur(fig2))
				fig2=TUR | _farbe(fig2);
			if(_istxkoe(fig2))
				fig2=KOE | _farbe(fig2);

			if(fig1 != fig2)
				break;
		}

		if(j==GROE)		/* Wiederholung gefunden 	*/
		{
			archiv[nr]->wdh=i;
			break;
		}
	}
}

/****************************************************************/
/*	Spieldaten zurueckholen					*/
/****************************************************************/
/*	0: Fehler	1: ok					*/
/****************************************************************/

int	hole_zurueck(dat,nr)

SPDAT	*dat;				/* Spieldaten		*/
int 	nr;				/* Zugnummer		*/
{
	if(nr>=MAXSP || nr<0)
		return(0);		/* Fehler		*/

	if(archiv[nr]==(ARCHIV *)0)	/* nicht belegt ?	*/
		return(0);		/* Fehler		*/

	dat->zuege=nr;			/* Zugnummer bestimmen	*/

	memcpy((char *)dat->brett,(char *)archiv[nr]->brett,GROE);
					/* Spielfeld kopieren	*/

	dat->farbe=archiv[nr]->farbe;	/* sonstige Daten kop.	*/
	dat->wkpos=archiv[nr]->wkpos;
	dat->skpos=archiv[nr]->skpos;
	dat->lzug =archiv[nr]->lzug;

	return(1);
}
