/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Interrupts				*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <signal.h>
#include "ad.h"

extern	void	exit();

/****************************************************************/
/*	Interrupt						*/
/****************************************************************/

void	ad_interrupt()

{
	inter=1;

	ad_deinit();			/* Deinitialsieren	*/
	exit(1);			/* Ende			*/
}

/****************************************************************/
/*	Refresh	 (^ L)						*/
/****************************************************************/

void	ad_refresh()

{
	WINDOW	*dwin;		/* neues Fenster	*/

	signal(SIGUSR1,SIG_IGN);
	signal(SIGALRM,SIG_IGN);

	inter=1;		/* Interrupt merken	*/

	dwin=newwin(LINES,COLS,0,0);
	wnoutrefresh(dwin);		/* ausgeben		*/
	delwin(dwin);		/* Fenster aus		*/

	touchwin(stdscr);	/* Fenster ausgeben	*/
	wnoutrefresh(stdscr);
	if(win != (WINDOW *)0)
	{
		touchwin(win);
		wnoutrefresh(win);
	}

	if(setupwin != (WINDOW *)0)
	{
		touchwin(setupwin);
		wnoutrefresh(setupwin);
	}

	doupdate();

	move(23,79);
	refresh();

	signal(SIGUSR1,ad_refresh);
}

/****************************************************************/
/*	"Best so far"						*/
/****************************************************************/

void	ad_break()

{
	extern	int beende;	/* aus ch_ma.c	*/

	inter=1;		/* Interrupt merken	*/

	signal(SIGUSR2,SIG_IGN);

	if(UEBUNG())
		beende=1;	/* beenden	*/

	signal(SIGUSR2,ad_break);
}

/****************************************************************/
/*	Interrupt starten					*/
/****************************************************************/

void	ad_startint()
{
	signal(SIGINT,ad_interrupt);	/* Interrupt aendern	*/
	signal(SIGTERM,ad_interrupt);
	signal(SIGHUP,ad_interrupt);

	signal(SIGUSR1,ad_refresh);	/* Bild neu aufb. (^ L)	*/
	signal(SIGUSR2,ad_break);	/* "Best so far"	*/
}
