/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Expire					*/
/*								*/
/****************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string.h>
#include <stdio.h>
#include <curses.h>

#include "ad.h"

/****************************************************************/
/*	Expire							*/
/****************************************************************/

void	ad_expire()

{
	char	c;
	int	i,j;
	DIR	*dir;	/* Directory - Struktur		*/
	struct	dirent	*dp;	/* Directorypointer	*/
	char	str[STRLEN],str2[STRLEN*5];	/* String	*/
	char	*s[3];
	char	white[STRLEN],black[STRLEN];	/* Namen der Spieler	*/
	struct	stat	sbuf;	/* Statusinfo.	*/

	lex();				/* Strings einlesen 	*/

	if( (dir=opendir("save"))==(DIR *)0 )	/* oeffnen	*/
	{
		ad_error("");		/* Fehler		*/
		return;
	}

	while( (dp=readdir(dir)) != (struct dirent *)0 )  /* Ende ?	*/
	{
		strcpy(str,dp->d_name);	/* kopieren		*/

		i=0;
		j=0;
		s[j++]=str;
		while(str[i]!='\0')		/* String aufbereiten	*/
		{
			if(str[i]=='.')
			{
				str[i++]='\0';	/* beenden	*/
				s[j++]=str+i;
			}

			if(j>=3)
				break;

			i++;
		}

		if(j==3)			/* Spiel gefunden ?	*/
		{
			double	days;

			sprintf(str2,"save/%s.%s.%s",s[0],s[1],s[2]);

			strcpy(white,ad_revid(s[0]));	/* Namen	*/
			strcpy(black,ad_revid(s[1]));

			if(stat(str2,&sbuf)== -1)
			{
				ad_error("");	/* Fehler		*/
				return;
			}

			days=(double)	/* Anzahl der Tage		*/
			(time((long *)0)-(long)sbuf.st_mtime) /
			(24.0 * 60.0 * 60.0) ;

			if(days > (double)(EXPIRE))	/* ueberschritten ? */
			{
			sprintf(str2,"loadinfo save/%s.%s",s[0],s[1]);
						/* Kommandostring   */
			schach(str2,ptr);	/* Info anfordern   */

			if(atoi(ptr[1]) > MOVES /* Mehr als MOVES Zuege ? */
			&& !(ptr[0][0]=='w' && s[0][0]=='~')
			&& !(ptr[0][0]=='s' && s[1][0]=='~'))
			/* Schwarz oder Weiss am Zug ?	*/
			{
				/* Highscoreeintrag	*/

				switch(ptr[0][0])	/* Farbe	*/
				{
				case 'w':		/* Weiss	*/
					ad_addscore_expire('B',white,black);
							/* Score 	*/

					if(s[0][0] != '~') /* Kein Comp. ? */
					{
					sprintf(str2,
"echo \"Chess game has timed out !\\nYou've lost the game \\\"%s vs. %s\\\".\" | %s %s",
					white,black,MAIL,white);
					system(str2);
					break;
					}

					if(s[1][0] != '~') /* Kein Comp. ? */
					{
					sprintf(str2,
"echo \"Chess game has timed out !\\nYou've won the game \\\"%s vs. %s\\\".\" | %s %s",
					white,black,MAIL,black);
					system(str2);
					break;
					}

				case 's':		/* Schwarz	*/
					ad_addscore_expire('W',white,black);
							/* Score 	*/

 					if(s[1][0] != '~') /* Kein Comp. ? */
					{
					sprintf(str2,
"echo \"Chess game has timed out !\\nYou've lost the game \\\"%s vs. %s\\\".\" | %s %s",
					white,black,MAIL,black);
					system(str2);
					break;
					}

					if(s[0][0] != '~') /* Kein Comp. ? */
					{
					sprintf(str2,
"echo \"Chess game has timed out !\\nYou've won the game \\\"%s vs. %s\\\".\" | %s %s",
					white,black,MAIL,white);
					system(str2);
					break;
					}
				}
			}
			else		/* Kein Verlierer	*/
			{
				if(s[0][0] != '~') 	/* Kein Comp. ? */
				{
				sprintf(str2,
"echo \"Chess game has timed out !\\nThe game \\\"%s vs. %s\\\" has been removed.\" | %s %s",
				white,black,MAIL,white);
				system(str2);
				}

				if(s[1][0] != '~') 	/* Kein Comp. ? */
				{
				sprintf(str2,
"echo \"Chess game has timed out !\\nThe game \\\"%s vs. %s\\\" has been removed.\" | %s %s",
				white,black,MAIL,black);
				system(str2);
				}
			}

			/* Spiel loeschen  */
			sprintf(str2,"save/%s.%s.ch",s[0],s[1]);
			if(unlink(str2) == -1)	/* loeschen		*/
				ad_error("");
			}
			else if(days > (double)(EXPIRE)-3.0) 
			{				/* Noch 3 Tage 	*/
				if(s[0][0] != '~') 	/* Kein Comp. ? */
				{
				sprintf(str2,
"echo \"Attention !\\nThe game \\\"%s vs. %s\\\" will expire in %d days.\" | %s %s",
				white,black,
				(int)(EXPIRE) - (int)days,
				MAIL,white);
				system(str2);
				}

				if(s[1][0] != '~') 	/* Kein Comp. ? */
				{
				sprintf(str2,
"echo \"Attention !\\nThe game \\\"%s vs. %s\\\" will expire in %d days.\" | %s %s",
				white,black,
				(int)(EXPIRE) - (int)days,
				MAIL,black);
				system(str2);
				}
			}

		}	/* Ende Spiel gefunden	*/

	}	/* Ende Directory lesen	*/

	closedir(dir);
}
