/****************************************************************/
/* Includefile fuer XChess V2.7 Curses Adapter			*/
/* (c) 1991 by M.Laukien					*/
/****************************************************************/

#define PTR		200	/* Anzahl der moeglichen Antworten	*/
#define STRLEN		81	/* Laenge von Strings			*/
#define ADM_RAND	12	/* Einruecken beim Administrationsmenue	*/
#define	MPOS		47	/* Position des Spielmenues		*/

#define PATT		1	/* Status	*/
#define W_MATT		2
#define S_MATT		3
#define W_AUFG		4
#define S_AUFG		5

#ifndef	WORKDIR
#define	WORKDIR	"."
#endif

#define	UEBUNG()	(gegner[0]=='\0')	/* Uebungsspiel		*/
#define	TURNIER()	(gegner[0]!='\0')	/* Turnierspiel		*/
#define	TURNGEG()	(gegner[0]!='\0' && gegner[0]!='~')
						/* Turnier gegen Gegner	*/
#define	TURNCOM()	(gegner[0]=='~')	/* Turnier gegen Comp.	*/

#define W_IS_USER()	(!wei)		/* Weiss ist User		*/
#define B_IS_USER()	(!sch)		/* Schwarz ist User		*/
#define W_IS_OPP()	(wei)		/* Weiss ist Gegner		*/
#define B_IS_OPP()	(sch)		/* Schwarz ist Gegner		*/

extern 	int	errno;			/* Fehlernummer 		*/
extern 	char	*sys_errlist[];		/* Fehlertexte 			*/

extern	char	*pname;			/* Prgname: argv[0] 		*/
extern	char	*cwd;			/* Working Directory 		*/
extern	char	stdname[];		/* Standardname fuers Speichern	*/
extern	char	def[];			/* Sprache 			*/
extern	int	lock;			/* Falls 1: Lock erworben	*/
extern	int	curses;			/* Falls 1: Curses an		*/
extern	int	inter;			/* Falls 1: Es war ein Interrupt*/
extern	int	break_pid;		/* Prozessid des Unterbrechers	*/
extern	WINDOW	*win;			/* Subwindow			*/
extern	WINDOW	*setupwin;		/* Setup-Subwindow		*/

extern	char	*amenu[];			/* Adm.-Menuestrings	*/
extern	char	*menu[];			/* Menuestrings		*/
extern	char	*smenu[];			/* Setup-Menuestrings	*/
extern	char	*info[];			/* Infostrings		*/
extern	char	*tr_lv;				/* Trainingslevel	*/
extern	char	*to_lv;				/* Turnierlevel		*/
extern	char	*press_key;			/* <Taste>		*/
extern	char	*tlist;				/* Ueberschrift Turnier	*/
extern	char	*ulist;				/* Ueberschrift Training*/
extern	char	*scorelist;			/* Ueberschrift Score	*/
extern	char	*sure;				/* Sicherheitsabfrage	*/
extern	char	*give_up;			/* Aufg. Abfrage	*/
extern	char	*figtab;			/* Figurentab.		*/
extern	char	*comp;				/* Computername		*/
extern	char	*white,*black;			/* Farben		*/
extern	char	*domove;			/* Zug			*/
extern	char	*doset;				/* Setup		*/
extern	char	*enter;				/* Namen eing.		*/
extern	char	*opponent;			/* Gegner eing.		*/
extern	char	*error;				/* Fehler		*/
extern	char	*not_allowed;			/* nicht erlaubt	*/
extern	char	*no_user;			/* kein User		*/
extern	char	*figlist;			/* geschl. Fig.		*/
extern	char	*ison,*isoff;			/* Ein/Aus		*/
extern	char	*thinking;			/* Comp. denkt		*/
extern	char	*is_thinking;			/* Gegner denkt		*/
extern	char	*load_lib;			/* Lade Eroeffnungen	*/
extern	char	*startcmd;			/* Startkommando	*/
extern	char	*patt,*w_mate,*b_mate;		/* Status		*/
extern	char	*w_chess,*b_chess;
extern	char	*w_up,*b_up;
extern	char	*remis_3;

extern	char	farbe;			/* w=weiss,s=schwarz		*/
extern	int	wei;			/* 0=Spieler			*/
extern	int	sch;			/* 1=Computer oder Gegener	*/
extern	char	gegner[];		/* Spielgegner (leer:Computer)	*/
extern	int	level;			/* Stufe			*/
extern	int	ende;			/* 1:Matt oder Patt		*/
extern	int	modus;			/* eingestellter Modus		*/

extern	int	old_moves;	/* Anzahl der Zuege bei Spielbeginn	*/

extern	char	ant[PTR][81];		/* Antworten			*/
extern	char	*ptr[PTR];		/* Pointer auf Antw.		*/

extern 	char 	*getcwd();		/* externe Funktionen		*/
extern 	char 	*getenv();
extern	char	*getlogin();
extern	int	atoi();
extern	int	unlink();

extern	void	ad_admin();		/* Administrationsmenue		*/
extern	void	ad_game();		/* Spielmenue			*/
extern	void	ad_tr_game();		/* Trainingsspiel		*/
extern	void	ad_tc_game();		/* Turnierspiel gegen Computer	*/
extern	void	ad_tu_game();		/* Turnierspiel gegen Gegner	*/
extern	void	ad_game_screen();	/* Spielscreen			*/
extern	void	ad_admin_screen();	/* Hauptmenue			*/
extern	void	ad_menu();		/* Menue ausgeben		*/
extern	void	ad_amenu();		/* Administrationsmenue ausg.	*/
extern	void	ad_status();		/* Status ausgeben		*/
extern	void	ad_analyse();		/* Analyse ausgabe		*/
extern	void	ad_tliste();		/* Turnierliste ausgeben	*/
extern	void	ad_uliste();		/* Uebungsspielliste		*/
extern	void	ad_break();		/* Denken abbrechen		*/
extern	void	ad_brett();		/* Brett ausgeben		*/
extern	void	ad_deinit();		/* Deinitialisierungen		*/
extern	void	ad_error();		/* Fehlermeldung		*/
extern	void	ad_msg();		/* Meldung			*/
extern	void	ad_flush();		/* Eingabe leeren		*/
extern	void	ad_info();		/* Informationen ausg.		*/
extern	void	ad_init();		/* Initialisierungen		*/
extern	void	ad_interrupt();		/* Interrupt			*/
extern	void	ad_new();		/* Programm Neustart		*/
extern	void	ad_remove();		/* Spiel loeschen		*/
extern	void	ad_refresh();		/* Refresh-Interrupt		*/
extern	void	ad_startint();		/* Interrupt starten		*/
extern	void	ad_zug();		/* Zug ausfuehren		*/
extern	void	ad_extzug();		/* externen Zug ausfuehren	*/
extern	void	ad_load();		/* Spiel laden			*/
extern	void	ad_save();		/* Spiel speichern		*/
extern	void	ad_lock();		/* File locken			*/
extern	void	ad_unlock();		/* File unlocken		*/
extern	void	ad_locksc();		/* Score locken			*/
extern	void	ad_unlocksc();		/* Score unlocken		*/
extern	void	ad_zurueck();		/* Zug zuruecknehmen		*/
extern	void	ad_showscore();		/* Highscoreliste ausgeben	*/
extern	void	ad_addscore();		/* Score eintragen		*/
extern	void	ad_addscore_expire();	/* dito. fuer expire		*/
extern	void	ad_expire();		/* Expire			*/
extern	void	ad_setup();		/* Setup-Menue			*/

extern	void	lex();			/* lex-Analyse			*/
extern	void	insert();		/* String einfuegen		*/

extern	char	*ad_name();		/* Name einlesen		*/
extern	char	*ad_id();		/* ID-String liefern		*/
extern	char	*ad_revid();		/* Name zu ID liefern		*/

extern	int	ad_domenu();		/* Menueauswertung		*/
extern	int	ad_read();		/* Eigenes read()		*/
extern	int	ad_sure();		/* Sicherheitsabfrage		*/
extern	int	main();			/* Hauptprogramm		*/
