#include <stdio.h>
#include <string.h>
#include <access.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>


char	*month[]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov", "Dec"};


/*******************************************************************************
* return the last character of a string, or \0 if string is empty              *
*******************************************************************************/
int	strlast (s) char *s;
{
	return *s==0 ? '\0' : s[strlen(s)-1];
}

/*******************************************************************************
* show contents of "undelete" directory (-> show deleted files)                *
*******************************************************************************/
void showdir ()
{
DIR		*dirp;
struct	dirent *dp;
char	dir[128], fname[128], d[128];
struct  stat	buff;
struct  tm	*ts;
int		i=0;

	sprintf (dir, "%s%s", UNDELETE, getcwd(d, 128));
	dirp=opendir (dir);
	if (dirp==NULL)
		fatal ("Cannot open %s}n",dir);
	printf ("Backup directory of %s\n", d);

	/* get filename(s) and time of last modification */
	while ((dp=readdir(dirp))!=NULL) {
		sprintf (fname,"%s/%s", dir, dp->d_name);
		if (stat (fname, &buff)==-1)
			fatal ("Cannot stat %s\n", fname);
		if ((buff.st_mode & S_IFDIR)!=S_IFDIR) {
			ts=localtime(&(buff.st_mtime));
			printf ("%02d. %s 19%2d %02d:%02d  %s\n",
				ts->tm_mday,month[ts->tm_mon],ts->tm_year,\
				ts->tm_hour, ts->tm_min,dp->d_name);
			i++;
		}
	}	
	closedir (dirp);
	if (i==0)
		printf ("No deleted files found\n");
	exit (0);
}


/*******************************************************************************
* Main module - test command line for options and filename                     *
*******************************************************************************/
void main (argc, argv) char *argv[];
{
char	fullpath[128], delpath[128];
int	c;

	if (argc!=2) 
		usage ("undelete file\nor\nundelete -l");

	if (strcmp (argv[1], "-l")==0)
		showdir ();
	if (strchr(argv[1], '/')!=NULL)
		fatal ("%s! undelete will work only in the current directory\n",argv[1]);

	/* create filename */
	getcwd (fullpath, 128);
	if (strlen(fullpath)>1)
		strcat (fullpath, "/");
	strcat (fullpath, argv[1]);

	/* get location of saved file */
	sprintf (delpath, "%s%s", UNDELETE, fullpath);

	/* is there a backup-file ? */
	if (access(delpath, AREAD)!=0)
		fatal ("\nEither there was no file %s in current path\nor the backup has ben deleted !\n", argv[1]);

	/* if file already exist, prompt for overwriting */
	if (access(fullpath, AEXISTS)==0) {
		printf ("%s already exists. Overwrite it [Y|N] ?", fullpath);
		do
			c=tolower(getchar());
		while ((c!='y') & (c!='n'));
		if (c=='n')
			return;
		if (unlink (fullpath) != 0)
			fatal ("undelete: cannot remove %s\n", fullpath);
	}
	if (link (delpath, fullpath) != 0)
		fatal ("undelete: cannot undelete %s\n", fullpath);
	if (execl (TOUCH, "touch", "-c", fullpath, NULL)==-1)
		fatal ("Cannot touch %s", fullpath);

}
