/*******************************************************************************
* del.c - (un)delete utility for Coherent                                            *
* syntax: del file [file] ...                                                  *
* 1993, Hans Elflein, Germany                                                  *
* Please, don't remove these lines                                             *
*******************************************************************************/

/*******************************************************************************
* The 1st step - some includes                                                 *
*******************************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <sys/stat.h>
#include <access.h>

/*******************************************************************************
* Create a directory for our deleted files                                     *
* Sorry, no recursion allowed                                                  *
* We must change mode, user and group of some directories. Because only root   *
* is allowed to change, we must setuid (0).                                    *
*******************************************************************************/
void makedir (dir) char *dir;
{
struct stat dest, source;
char temp[128], src[128], *pos;
int	i=0, real_id, indel=0;

	real_id=getuid();
	setuid(0) ;
	strcpy (src, dir);
	sprintf (temp,"%s%s", UNDELETE, dir);
	while ((pos=strchr(temp+i+1, '/'))!=NULL) {
		*pos='\0';
		if (strncmp (temp, UNDELETE, strlen(UNDELETE))==0)
			++indel;

	/* If we can't stat 'temp', it doesnt exist */
		if (stat(temp, &dest)!=0) {
			if (mkdir (temp, 0777)!=0)
				fatal ( "del: cannot create %s\n",temp);
			if (indel>1) {
				strcpy (src, temp+strlen(UNDELETE));
	/* Get mode of original directory */
				stat (src, &source);
				chmod (temp, source.st_mode & 07777);
				chown (temp, source.st_uid, source.st_gid);
			}
			else
				chmod (temp, 0777);
		}
	/* temp already exists. Is it directory ? */
		else 
			if ((dest.st_mode & S_IFDIR) != S_IFDIR)
				fatal ( "del: cannot create %s\n",temp);

	/* get next part of subdirectory */
		*pos='/';
		i=pos-temp;
	}

	/* Create last part of subdirectory */
	if (stat(temp, &dest)!=0) {
		if (mkdir (temp, 0777)!=0)
			fatal ("del: cannot create %s\n", temp);
		if (indel>1) {
			strcpy (src, temp+strlen(UNDELETE));
			stat (src, &source);
			chmod (temp, source.st_mode & 07777);
			chown (temp, source.st_uid, source.st_gid);
		}
		else
			chmod (temp, 0777);
	}
	else {
		if ((dest.st_mode & S_IFDIR) != S_IFDIR)
			fatal ("del: cannot create %s\n", temp);
	}

	/* Important! Don't remove the next command ! */
	setuid (real_id);
}

/*******************************************************************************
* Get directory and basename of specified file                                 *
*******************************************************************************/
void getdir (dir, basename, filename) char *dir, *basename, *filename;
{
char	*pos, old[128];

/* If filename does NOT contain a slash, then basename=filename and           */
/* directory = cwd                                                            */
	if ((pos=strrchr (filename, '/'))==NULL) {
		getcwd (dir, 128);
		strcpy (basename, filename);
	}
	else {
/* Let the system handle expressions like 'del ../../foo/foo'                 */
		*pos='\0';
		getcwd (old, 128);
		chdir (filename);
		getcwd (dir, 128);
		chdir (old);
		strcpy (basename, pos+1);
	}
}

/*******************************************************************************
* Copy file(s) to UNDELETE-directory and remove the original                   *
*******************************************************************************/
void copy (directory, file) char *directory, *file;
{
char source[128], dest[128];
int c;

	sprintf (source, "%s/%s", 
		strcmp(directory, "/")==0 ? "" : directory, file);
	sprintf (dest, "%s%s/%s", 
		UNDELETE, strcmp(directory, "/")==0 ? "" : directory, file);

	if (access (dest, AEXISTS) == 0) {
		fprintf (stderr, "%s already exists. Overwrite it [y|n]? ", dest);
			do
				c=tolower(getchar());
			while ((c!='y')&&(c!='n'));
			if (c=='n')
				return;
		if (unlink(dest) != 0)
			fatal ("del: cannot remove %s\n", dest);
	}
	if (link (source, dest)!=0)
		fatal ("del: cannot link %s to %s\n", source, dest);
	if (unlink (source) != 0)
		fatal ("fata: cannot unlink %s\n", source);
	if (fork()==0) {
		if (execl (TOUCH, "touch", "-c", dest, NULL)==-1) {
			fatal ("del: cannot touch %s\n", dest);
		}
	}
	else
		wait ();
}

/*******************************************************************************
* Main module. Wildcards are expanded by the shell                             *
*******************************************************************************/
int main(argc, argv) int argc; char *argv[];
{
int		i;
char	dirs[128], fs[128];

	if (argc<2) 
		usage ("del file[s]\n");

/* Test access for every file */
	for (i=1;i<argc;i++) {
		if (access (argv[i], AEXISTS)!=0) {
			fprintf (stderr, "del: cannot access %s\n", argv[i]);
			continue;
		}
		if (access (argv[i], ADEL)!=0) {
			fprintf (stderr, "del: %s: permission denied\n", argv[i]);
			continue;
		}
		getdir (dirs, fs, argv[i]);

/* Avoid deleteing in the UNDELETE-directory */
/* If not, this can produce a very nice recursion */
		if (strncmp(dirs, UNDELETE, strlen (UNDELETE))!=0) {
			makedir (dirs);
			copy (dirs, fs);
		}
		else
			printf ("Cannot delete %s in backup directory\n", fs);
	}
	return 0;
}
