/*******************************************************************************
* cleanup.c - utility for Coherent undelete                                    *
* remove deleted files older than (MAXDAYS) days                               *
* syntax: cleanup                                                              *
* 1993, Hans Elflein, Germany                                                  *
* Please, don't remove these lines                                             *
*******************************************************************************/
#include <stdio.h>
#include <sys/stat.h>
#include <dirent.h>
#include <time.h>
#include <errno.h>

/* How many seconds are MAXDAYS ? */
#define	SECONDS		(long)MAXDAYS*24L*60L*60L

int		 debug=0, dcount=0, fcount=0;
char	*getcwd();

/*******************************************************************************
* Avoid deleteing in special directories                                       *
*******************************************************************************/
test_del (dir) char *dir;
{
DIR 	*dirp;
struct	dirent	*dp;

	if (strcmp(dir, ".")==0)		/* Avoid deleting of "." */
		return 0;
	if (strcmp(dir, "..")==0)		/* Avoid deleting of ".." */
		return 0;
	if (strcmp(dir, UNDELETE)==0)	/* Avoid deleting of UNDELETE */
		return 0;

	/* Don't try to delete a subdirectory if it is not empty */
	dirp=opendir ( dir );

	/* If we cannot open subdirectory, don't try to remove it */
	if (dirp == NULL)
		return 0;

	/* Read 1st entry -> "." */
	dp = readdir( dirp );

	/* Read 2nd entry -> ".." */
	dp = readdir( dirp );

	/* Any more ? */
	dp = readdir( dirp );

printf ("test_del found 3rd entry = %s\n", dp->d_name);
	closedir ( dirp );
	return ( dp == NULL ? 1 : 0 );

}

/*******************************************************************************
* Scan UNDELETE area                                                           *
*******************************************************************************/
void tree (dir) char *dir;
{
DIR 	*dirp;
struct	dirent	*dp;
struct	stat	sbuff, dirbuff;
char	pfad[200];
time_t	t;

	/* Get current time */
	t=time (NULL);
	if (chdir(dir)==-1)
		fatal ("cleanup: cannot chdir to %s", dir);

	if (getcwd(pfad, 200)==NULL)
		fatal ("cleanup: cannot get cwd");

	/* open directory */
	if ((dirp=opendir (pfad)) != NULL) {
		if (stat (pfad, &dirbuff)==-1)
			fatal ("cleanup: cannot stat %s", pfad);

	/* search directory */
		while ( (dp = readdir( dirp )) != NULL ) {

	/* Get status of dp->d_name */
			if (stat (dp->d_name, &sbuff)==-1)
				fatal ("cleanup: cannot stat %s", dp->d_name);

	/* If dp->d_name is a subdirectory. Scan it too  */
	/* But don't scan "." and ".." (I like recursion)*/
			if ((sbuff.st_mode&S_IFDIR)==S_IFDIR) {
				if (strcmp(dp->d_name, ".")==0)
					continue;
				if (strcmp(dp->d_name, "..")==0)
					continue;
				tree (dp->d_name);
			}
			else

	/* O.k. - dp->d_name is not a subdirectory. Check last modification */
	/* time, compare with SECONDS and (perhaps) remove file .           */
				if ((t-sbuff.st_mtime)>=SECONDS) {
					if (debug)
						printf ("Deleting file %s/%s\n",pfad, dp->d_name);
					if (unlink (dp->d_name)==-1)
						fatal ("cleanup: cannot unlink %s", dp->d_name);
					else
						fcount++;
				}
		}
		
	/* close directory */
		closedir (dirp);

	/* Back to parent directory - part of recursion */
		chdir ("..");

	/* Check last modification time of subdirectory, compare with */
	/* SECONDS and (perhaps) remove subdirectory .                */
		if ((t-dirbuff.st_mtime)>=SECONDS) 
			if (test_del(pfad)!=0) {
			if (debug)
				printf ("Removing directory %s\n",pfad);
			if (rmdir (pfad)==-1)
				fatal ("cleanup: cannot remove subdirectory %s", pfad);
			else
				dcount++;
		}
	}
}

/*******************************************************************************
* main module - nothing to explain                                             *
*******************************************************************************/
int main(argc, argv) char *argv[];
{
	if (argc>1)
		if (strcmp (argv[1], "-debug")==0)
			debug=1;
	if (debug)
		printf ("Cleaning up backup-directory\n");
	tree (UNDELETE);
	if (debug)
		printf ("%d files and %d subdirectories deleted\n", fcount, dcount);
	return 0;
}
