/* $Id: porttree.c,v 3.3 1991/09/01 14:03:49 piggy Rel $
 * Port tree management
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int InsertPort(char * port)
 *	Look for port in the tree. If it is already there, return a pointer
 *	to its info. Otherwise make a new entry and initialize it.
 *
 * void EnquiryPort(void (*funct)(portact_t port))
 *	For each node in the tree, process it through funct.
 *
 * void KillPort(char * port)
 *	Do not show that port in any report.
 *
 */

#include <stdio.h>
#include "mem.h"
#include <string.h>
#include "hdbstat.h"

typedef struct porttree
{
  portact_t Node;
  struct porttree *L;
  struct porttree *R;
} porttree_t;

#define TNULL	(porttree_t *) NULL

static FlistHead PortFlist =
{
  0, 0, 0
};

static porttree_t *Root = TNULL;

static portact_t *
PortTree (tree, port)
     porttree_t **tree;
     char *port;
{
  int cmpres;

  if (*tree == TNULL)
    {
      register portact_t *sr;
      int idx;

      if (PortFlist.size == 0)
	MemInit (&PortFlist, sizeof (porttree_t), 5, 5);
      *tree = (porttree_t *) new (&PortFlist);
      (*tree)->L = (*tree)->R = TNULL;
      sr = &((*tree)->Node);
      sr->Port = strdup (port);
      sr->Killed = FALSE;
      for (idx = 0; idx < TIMESLICES; idx++)
	sr->Activity[idx] = 0.0;
      return (&(*tree)->Node);
    }
  else if ((cmpres = strcmp (port, (*tree)->Node.Port)) < 0)
    return PortTree (&(*tree)->L, port);
  else if (cmpres > 0)
    return PortTree (&(*tree)->R, port);
  else
    return (&(*tree)->Node);
}

portact_t *
InsertPort (port)
     char *port;
{
  return PortTree (&Root, port);
}

void
KillPort (port)
     char *port;
{
  PortTree (&Root, port)->Killed = TRUE;
}

static void
ProcPortTree (tree, funct)
     porttree_t *tree;
     void (*funct) ();
{
  if (tree != TNULL)
    {
      ProcPortTree (tree->L, funct);
      if (!(tree->Node.Killed))
	(*funct) (tree->Node);
      ProcPortTree (tree->R, funct);
    }
}

void
EnquiryPort (funct)
     void (*funct) ();
{
  ProcPortTree (Root, funct);
}
