/* $Id: phonesw.c,v 3.3 1991/09/01 14:03:52 piggy Rel $
 * Return an index based on the day, hour and minute we are working
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int  GetPhonePrice(int day, int hour, int minute)
 *      Return an index in PHONE_PRICING_TB_NAMES, calculated from day, hour,
 *      minute.
 *
 * NOTE: Probably you'll need to customize this function for your country.
 *       Please, include your code, if any, between ifdefs, as I did, and
 *       send me the diffs, so I can keep this file up to date ;-)
 */

#include "hdbstat.h"

/*
 * ITALY
 */
#ifdef ITALY

#define PEAK_TIME       0
#define NORMAL_TIME     1
#define EVENING_TIME    2
#define NIGHT_TIME      3

char *PhoneCategoryNames[] =
{
  "Peak Time   ",		/* 8:30am to 1pm */
  "Normal Time ",		/* 8am to 8:30am, 1pm to 6:30pm */
  "Evening Time",		/* 6:30pm to 10pm */
  "Night Time  "		/* 10pm to 8 am */
};

/*
 * This function get the Day of the Week, the Hour, and the Minute, and
 * return an integer indicating in which timebelt we are.
 */

int
GetPhonePrice (day, hour, min)
     int day, hour, min;

{
  int retvalue;
  
  switch (day)
    {
    case 0:			/* Sunday */
      retvalue = ((hour < 8 || hour >= 22) ? NIGHT_TIME : EVENING_TIME);
      break;

    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      if (hour < 8 || hour >= 22)
	retvalue = NIGHT_TIME;
      else if (hour > 18 || (hour == 18 && min >= 30))
	retvalue = EVENING_TIME;
      else if ((hour > 8 && hour < 13) || (hour == 8 && min >= 30))
	retvalue = PEAK_TIME;
      else retvalue = NORMAL_TIME;
      break;
      
    case 6:			/* Saturday */
      if (hour < 8 || hour >= 22)
	retvalue = NIGHT_TIME;
      else if (hour >= 8 && hour < 13)
	retvalue = PEAK_TIME;
      else retvalue = EVENING_TIME;
      break;
    }
  return retvalue;
}

#undef PEAK_TIME
#undef NORMAL_TIME
#undef EVENING_TIME
#undef NIGHT_TIME
#endif /* ifdef ITALY */

/*
 * UNITED KINGDOM
 */
#ifdef UK

#define	UK_PEAK		0
#define	UK_NORMAL	1
#define	UK_CHEAP	2

char *PhoneCategoryNames[] =
{
  "Peak Rate   ",		/* UK_PEAK	9:00am to 1pm */
  "Normal Rate ",		/* UK_NORMAL	8am to 9.00am, 1pm to 6:00pm */
  "Cheap Rate  "		/* UK_CHEAP	6pm to 8 am */
};

/*
 * This function get the Day of the Week, the Hour, and the Minute, and
 * return an integer indicating in which timebelt we are.
 */

int
GetPhonePrice (day, hour, min)
     int day, hour, min;

{
  int retvalue;
  
  switch (day)
    {
    case 0:			/* Sunday */
    case 6:			/* Saturday */
      retvalue = UK_CHEAP;
      break;

    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      if (hour < 8 || hour >= 18)
	retvalue = UK_CHEAP;
      else if (hour >= 9 && hour < 13)
	retvalue = UK_PEAK;
      else
	retvalue = UK_NORMAL;
      break;
    }
  return retvalue;
}

#undef	UK_PEAK	
#undef	UK_NORMAL
#undef	UK_CHEAP

#endif /* ifdef UK */

