
#include <termio.h>
#if defined(COHERENT) && !defined(_I386)
#include <sys/fcntl.h>
#include <sys/timeb.h>
#else
#include <fcntl.h>
#endif
#include <sys/param.h>
#include <sys/types.h>

#ifndef USENAP
#ifdef USEPOLL
#ifndef __COHERENT__
#include <sys/poll.h>
#else
#include <poll.h>
#endif
#else
#define USETIMES	1
#include <sys/times.h>
#endif
#endif

static struct termio orig;

#ifdef DONTHOG
static char timings[] = { 30, 20, 20, 20, 10, 10 };
#else
static char timings[] = { 30, 25, 20, 15, 10, 8 };
#endif
static int  currtim;

extern int speed;

setuptty() {
	struct termio tt;
	static int getdone = 0;

	if ( !getdone ) {
		ioctl(0,TCGETA,&orig);
		getdone = 1;
	}
	memcpy( (char*)&tt, (char*)&orig, sizeof(orig) );
	tt.c_cc[VMIN] = 0;
	tt.c_cc[VTIME] = 1;
	ioctl(0,TCSETA,&tt);
}

closeuptty() {
	ioctl(0,TCSETA,&orig);
}

setlevel(level)
{
	if ( level >= sizeof(timings) )
		level = sizeof(timings) - 1;
	currtim = timings[level];
}

polluser(buf,sizebuf)
char *buf;
int sizebuf;
{
	static int timeleft = 0;
	int nc;

	if ( timeleft <= 0 )
		timeleft = currtim;
	if ( timeleft < 10 ) {
		wait_ms(timeleft*(speed/10));
		fcntl(0,F_SETFL,O_NDELAY);
		nc = read(0,buf,sizebuf);
		fcntl(0,F_SETFL,0);
		timeleft = 0;
	} else {
/* This ifdeffing of USETIMES makes no sense to me, so I've commented it out. -mk */
/* #ifdef USETIMES
		nc = read(0,buf,sizebuf);
#else */
		wait_ms(speed);
		fcntl(0,F_SETFL,O_NDELAY);
		nc = read(0,buf,sizebuf);
		fcntl(0,F_SETFL,0);
/* #endif */
		timeleft -= 10;
	}
#ifdef COHERENT
	if(nc == -1) nc = 0;  /* A kludge...weird that read() sometimes returns -1 for no reason. */
#endif
	if ( timeleft <= 0 )
		buf[nc++] = 0;		/* not an eos but the signal to drop */
	return nc;
}

#if defined(COHERENT) && !defined(_I386)
static wait_ms( msecs )
int msecs;
{
  struct timeb tmbuf;
  time_t untiltime;
  unsigned short untilmsecs;

  /* Figure out when we can return */
  ftime(&tmbuf);
  untiltime = tmbuf.time + ((long)(msecs / 1000));
  untilmsecs = tmbuf.millitm + (msecs % 1000);
  if(untilmsecs > 990) { /* milliseconds rolled over */
    untiltime++;
    untilmsecs -= 990;
    }

  /* Wait until we can return.  Warning, this is a BIG CPU hog. */
  for(;;) {
    ftime(&tmbuf);
    if((tmbuf.time >= untiltime) && (tmbuf.millitm >= untilmsecs))
      return;
    }
}
#else
static wait_ms( msecs )
{
#ifdef USETIMES
	register time_t etime;
	long times();
	struct tms junk;

	etime = times(&junk) + ((HZ * msecs) + 999) / 1000;
	while ( times(&junk) <= etime )
		;
#endif
#ifdef USEPOLL
	struct pollfd	fda[1];
	
	fda[0].fd = -1;
	poll( (struct pollfd*) &fda[0], 1, msecs );
#endif
#ifdef USENAP
	nap( ((HZ * msecs) + 999) / 1000 ) ;
#endif
}
#endif
