#define		LIBDIR		"/usr/lib/news"
#define		SPOOLDIR	"/usr/spool/news"
#define		MAILER		"/bin/rmail"
#define		DEF_EDITOR	"/usr/bin/vi"

#define		TRUE		1
#define		FALSE		0

#define		LEN		200

#define		INDEX_TOP	4
#define		NOTESLINES	(LINES - INDEX_TOP - 2)
#define		RIGHT_POS	(COLS - 16)
#define		MORE_POS	(COLS - 20)

#define		MAX_FROM	25
#define		MAX_SUBJ	38
#define		TABLE_SIZE	1409		/* should be prime */



struct header {
	long artnum;
	char *subject;
	char *from;
	int thread;
	int inthread;
	int unread;		/* has this article been read? */
				/* 0 = read, 1 = unread, 2 = will return */
};

/*
 *  header.artnum:
 *	article number in spool directory for group
 *
 *  header.thread:
 *	initially -1
 *	points to another arts[] (struct header): zero and up
 *	-2 means article has expired (wasn't found in file search
 *	of spool directory for the group)
 *
 *  header.inthread:
 *	FALSE for the first article in a thread, TRUE for all
 *	following articles in thread
 *
 *  header.read:
 *	boolean, has this article been read or not
 */

struct group_ent {
	char *name;
	long max;
	long min;
	int next;		/* next active entry in hash chain */
	int flag;
};

#define		NOTGOT		0x01	/* haven't put in my_group yet */
#define		SUBS		0x02	/* subscribed to */


extern int top;
extern struct header *arts;
extern long *base;
extern int max_art;

extern char sig[LEN];
extern char signature[LEN];
extern char userid[LEN];
extern char homedir[LEN];
extern char indexdir[LEN];
extern char my_org[LEN];
extern char active_file[LEN];
extern char newsrc[LEN];
extern char newnewsrc[LEN];
extern char delgroups[LEN];
extern int top_base;
extern int LINES, COLS;
extern char *str_save();
extern char *my_malloc();
extern char *my_realloc();
extern int group_hash[TABLE_SIZE];

extern int num_active;
extern struct group_ent *active;
extern int *my_group;
extern int *unread;
extern int max_active;

extern int local_top;
extern char *eat_re();
extern char *nice_time();
extern int update;
extern int inverse_okay;

extern int tass_uid;
extern int tass_gid;
extern int real_uid;
extern int real_gid;
extern int local_index;

extern char *strcpy();
extern char *strncat();
extern char *strncpy();
extern long atol();


#define		ctrl(c)			((c) & 0x1F)

/*
 *  Assertion verifier
 */

#ifdef __STDC__
#define	assert(p)	if(! (p)) asfail(__FILE__, __LINE__, #p); else
#else
#define	assert(p)	if(! (p)) asfail(__FILE__, __LINE__, "p"); else
#endif

#define		TASS_HEADER	"Tass 3.2"
