#include	<stdio.h>
#include	<ctype.h>
#include	<signal.h>
#include	<pwd.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	"tass.h"


char active_file[LEN];
char homedir[LEN];
char userid[LEN];
char delgroups[LEN];
char newsrc[LEN];
char newnewsrc[LEN];
char indexdir[LEN];
char my_org[LEN];		/* organization */
char sig[LEN];
char signature[LEN];


/*
 *  Which base note (an index into base[]) does a respnum
 *  (an index into arts[]) corresponsd to?
 *
 *  In other words, base[] points to an entry in arts[] which is
 *  the head of a thread, linked with arts[].thread.  For any q: arts[q],
 *  find i such that base[i]->arts[n]->arts[o]->...->arts[q]
 */

which_base(n)
int n;
{
	int i, j;

	for (i = 0; i < top_base; i++)
		for (j = base[i]; j >= 0; j = arts[j].thread)
			if (j == n)
				return i;

	fprintf(stderr, "can't find base article\n");
	return 0;
}


/*
 *  Find how deep in a thread a response is.  Start counting at zero
 */

which_resp(n)
int n;
{
	int i, j;
	int num = 0;

	i = which_base(n);

	for (j = base[i]; j != -1; j = arts[j].thread)
		if (j == n)
			break;
		else
			num++;

	return num;
}


/*
 *  Given an index into base[], find the number of responses for
 *  that basenote
 */

nresp(n)
int n;
{
	int i;
	int oldi = -3;
	int sum = 0;

	assert(n < top_base);

	for (i = base[n]; i != -1; i = arts[i].thread) {
		assert(i != -2);
		assert(i != oldi);
		oldi = i;
		sum++;
	}

	return sum - 1;
}


asfail(file, line, cond)
char	*file;
int	line;
char	*cond;
{
	fprintf(stderr, "tass: assertion failure: %s (%d): %s\n",
							file, line, cond);
	exit(1);
}


/*
 * init_selfinfo
 *   Deterimines users home directory, userid, and a path
 *   for an rc file in the home directory
 */
/* Don't know why, but "\0" at sprintf statements fixed some bugs */
init_selfinfo()
{
	struct passwd *myentry;
	extern struct passwd *getpwuid();
	struct stat sb;
	char nam[LEN];
	char *p;
	extern char *getenv();
	FILE *fp;

	myentry = getpwuid(getuid());
	strcpy(userid, myentry->pw_name);
	strcpy(homedir, myentry->pw_dir);

	sprintf(signature, "%s/.signature\0", homedir);
	sprintf(sig, "%s/.Sig\0", homedir);
	sprintf(newsrc, "%s/.newsrc\0", homedir);
	sprintf(newnewsrc, "%s/.newnewsrc\0", homedir);
	sprintf(delgroups, "%s/.delgroups\0", homedir);
	sprintf(indexdir, "%s/.tindx\0", homedir);
	sprintf(active_file, "%s/active\0", LIBDIR);
	if (stat(active_file, &sb) >= 0)
		goto got_active;

/*
 *  I hate forgetting to define LIBDIR correctly.  Guess a
 *  couple of likely places if it's not where LIBDIR says it is.
 */

	strcpy(active_file, "/usr/lib/news/active");
	if (stat(active_file, &sb) >= 0)
		goto got_active;

	strcpy(active_file, "/usr/local/lib/news/active");
	if (stat(active_file, &sb) >= 0)
		goto got_active;

	strcpy(active_file, "/usr/public/lib/news/active");
	if (stat(active_file, &sb) >= 0)
		goto got_active;

/*
 *  Oh well.  Revert to what LIBDIR says it is to produce a
 *  useful error message when read_active() fails later.
 */

	sprintf(active_file, "%s/active\0", LIBDIR);

got_active:

	*my_org = '\0';
	p = getenv("ORGANIZATION");
	if (p != NULL) {
		strcpy(my_org, p);
		goto got_org;
	}

	sprintf(nam, "%s/organization\0", LIBDIR);
	fp = fopen(nam, "r");

	if (fp == NULL) {
		sprintf(nam, "/usr/lib/news/organization");
		fp = fopen(nam, "r");
	}

	if (fp == NULL) {
		sprintf(nam, "/usr/local/lib/news/organization");
		fp = fopen(nam, "r");
	}

	if (fp == NULL) {
		sprintf(nam, "/usr/public/lib/news/organization");
		fp = fopen(nam, "r");
	}

	if (fp == NULL) {
		sprintf(nam, "/etc/organization");
		fp = fopen(nam, "r");
	}

	if (fp != NULL) {
		if (fgets(my_org, LEN, fp) != NULL) {
			for (p = my_org; *p && *p != '\n'; p++) ;
			*p = '\0';
		}
		fclose(fp);
	}

got_org:;

}


char *
my_malloc(size)
unsigned size;
{
	char *p;
	extern char *malloc();

	p = malloc(size);
	if (p == NULL) {
		fprintf(stderr, "tass: out of memory\n");
		exit(1);
	}
	return p;
}


char *
my_realloc(p, size)
char *p;
unsigned size;
{
	extern char *malloc();
	extern char *realloc();

	if (p == NULL)
		p = malloc(size);
	else
		p = realloc(p, size);

	if (p == NULL) {
		fprintf(stderr, "tass: out of memory\n");
		exit(1);
	}
	return p;
}


char *
str_save(s)
char *s;
{
char *p;

	assert(s != NULL);
	
	p = my_malloc(strlen(s) + 1);
	strcpy(p, s);

	return(p);
}


copy_fp(a, b, prefix)
FILE *a;
FILE *b;
char *prefix;
{
	char buf[8192];

	while (fgets(buf, 8192, a) != NULL)
		fprintf(b, "%s%s", prefix, buf);
}


char *
get_val(env, def)
char *env;		/* Environment variable we're looking for	*/
char *def;		/* Default value if no environ value found	*/
{
	extern char *getenv();
	char *ptr;

	if ((ptr = getenv(env)) != NULL)
		return(ptr);
	else
		return(def);
}


invoke_editor(nam)
char *nam;
{
	char buf[200];
	static int first = TRUE;
	static char editor[200];
	int ret;

	if (first) {
		strcpy(editor, get_val("EDITOR", DEF_EDITOR));
		first = FALSE;
	}

	sprintf(buf, "%s %s", editor, nam);
	printf("\r%s\n", buf);
	ret = invoke_cmd(buf);
	setuid(real_uid);
	setgid(real_gid);

	return ret;
}


invoke_cmd(nam)
char *nam;
{
	int ret;
#ifdef SIGTSTP
	void (*susp)();
#endif

	Raw(FALSE);
	setuid(real_uid);
	setgid(real_gid);

#ifdef SIGTSTP
	susp = signal(SIGTSTP, SIG_DFL);
#endif

	ret = system(nam);

#ifdef SIGTSTP
	signal(SIGTSTP, susp);
#endif

	setuid(tass_uid);
	setgid(tass_gid);
	Raw(TRUE);

	return ret == 0;
}


shell_escape() {
	char shell[LEN];
	char *p;
#ifdef SIGTSTP
	void (*susp)();
#endif

	if (!parse_string("!", shell))
		strcpy(shell, get_val("SHELL", "/bin/sh"));

	for (p = shell; *p && (*p == ' ' || *p == '\t'); p++) ;

	if (!*p)
		strcpy(shell, get_val("SHELL", "/bin/sh"));
	
	Raw(FALSE);

	setuid(real_uid);
	setgid(real_gid);

	fputs("\r\n", stdout);

#ifdef SIGTSTP
	susp = signal(SIGTSTP, SIG_DFL);
#endif

	system(p);

#ifdef SIGTSTP
	signal(SIGTSTP, susp);
#endif

	setuid(tass_uid);
	setgid(tass_gid);

	Raw(TRUE);

	continue_prompt();
	mail_setup();
}


/*
 *  Find the previous response.  Go to the last response in the previous
 *  thread if we go past the beginning of this thread.
 */

prev_response(n)
int n;
{
	int resp;
	int i;

	resp = which_resp(n);

	if (resp > 0)
		return choose_resp( which_base(n), resp-1 );

	i = which_base(n) - 1;

	if (i < 0)
		return -1;

	return choose_resp( i, nresp(i) );
}


/*
 *  Find the next response.  Go to the next basenote if there
 *  are no more responses in this thread
 */

next_response(n)
int n;
{
	int i;

	if (arts[n].thread >= 0)
		return arts[n].thread;

	i = which_base(n) + 1;

	if (i >= top_base)
		return -1;

	return base[i];
}


/*
 *  Given a respnum (index into arts[]), find the respnum of the
 *  next basenote
 */

next_basenote(n)
int n;
{
	int i;

	i = which_base(n) + 1;
	if (i >= top_base)
		return -1;

	return base[i];
}



/*
 *  Find the next unread response in this group 
 */

next_unread(n)
int n;
{

	while (n >= 0) {
		if (arts[n].unread == 1)
			return n;
		n = next_response(n);
	}

	return -1;
}


/*
 *  Find the previous unread response in this thread
 */

prev_unread(n)
int n;
{

	while (n >= 0) {
		if (arts[n].unread == 1)
			return n;
		n = prev_response(n);
	}

	return -1;
}


add_signature(fp, flag)
FILE *fp;
int flag;
{
	FILE *sigf;

	sigf = fopen(signature, "r");
	if (sigf != NULL) {
		if (flag) {
			fprintf(fp, "\n--\n");
			copy_fp(sigf, fp, "");
		}
		fclose(sigf);
		return;
	}

	sigf = fopen(sig, "r");
	if (sigf != NULL) {
		fprintf(fp, "\n--\n");
		copy_fp(sigf, fp, "");
		fclose(sigf);
	}
}


make_lower(s, t)
char *s;
char *t;
{

	while (*s) {
		if (isupper(*s))
			*t = tolower(*s);
		else
			*t = *s;
		s++;
		t++;
	}
	*t = 0;
}


match(s, t, n)
char *s;
char *t;
int n;
{

	while (*t) {
		if (*s == *t && strncmp(s, t, n) == 0)
			return TRUE;
		t++;
	}

	return FALSE;
}
