#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

int
sowrite(fildes, buf, nbytes)
int fildes, nbytes;
char *buf;
{
	register struct socket *so;
	int cc;

	if ((so = GETSOCKET(fildes)) == NULL)
		return -1;
	if ((so->so_state & SS_ISCONNECTED) == 0) {
		errno = ENOTCONN;
		return -1;
	}
	cc = write(so->so_wfd, buf, nbytes);
	if (so->so_state & SS_NBIO && cc == 0) {
		errno = EWOULDBLOCK;
		return -1;
	}
	return cc;
}
