#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

int
soread(fildes, buf, nbytes)
int fildes, nbytes;
char *buf;
{
	register struct socket *so;
	int cc;

	if ((so = GETSOCKET(fildes)) == NULL)
		return -1;
	if ((so->so_state & SS_ISCONNECTED) == 0) {
		errno = ENOTCONN;
		return -1;
	}
	cc = read(so->so_rfd, buf, nbytes);
	if (cc == 0 && (so->so_state & SS_NBIO) == 0) {
		/*
		 * Use may have set FNDELAY with a fcntl.
		 * check it out here. The other solution would
		 * be to trap the fcntls, and check the arguments.
		 */
		if (fcntl(so->so_rfd, F_GETFL, 0) & O_NDELAY)
			so->so_state |= SS_NBIO;
		else {
			/*
			 * Why did we come here?
			 * Maybe connection is severed.
			 */
		}
	}
	if (so->so_state & SS_NBIO && cc == 0) {
		errno = EWOULDBLOCK;
		return -1;
	}
	return cc;
}
