#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

extern void free();

int
soclose(fildes)
int fildes;
{
	register struct socket *so;

	if ((so = GETSOCKET(fildes)) == NULL)
		return -1;
	if (so->so_state & SS_ISCONNECTED) {
		if (_sodisconnect(so) == -1)
			return -1;
	}
	close(so->so_fd);
	unlink(so->so_name);
	if (so->so_name)
		free((char *)so->so_name);
	if (so->so_addr)
		free((char *)so->so_addr);
	_socktab[fildes] = NULL;
	free((char *)so);
	return 0;
}

/*
 * Disconnect socket connection, and notify other side.
 */
int
_sodisconnect(so)
register struct socket *so;
{
	struct socket_packet msg;
	int cc;

	if ((so->so_state & SS_ISCONNECTED) == 0) {
		errno = ENOTCONN;
		return -1;
	}
	msg.scm_magic = SOCKET_MAGIC;
	msg.scm_msg = MSG_DISCONNECT;
	msg.scm_type = so->so_type;
	cc = write(so->so_pfd, (char *)&msg, sizeof(msg));
	return _sodisconnect2(so);
}

/*
 * Come here if socket should be disconnected without 
 * notifying the other side.
 */
int
_sodisconnect2(so)
register struct socket *so;
{
	char fname[80];

	if (so->so_state & SS_ISCONNECTED) {
		close(so->so_rfd);
		close(so->so_wfd);
		close(so->so_pfd);
		sprintf(fname, "/tmp/%s", so->so_rname);
		unlink(fname);
		sprintf(fname, "/tmp/%s", so->so_wname);
		unlink(fname);
		free((char *)so->so_conn);
		so->so_conn = NULL;
		so->so_state &= ~SS_ISCONNECTED;
	}
	return 0;
}
