#include <stdio.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include "netdb.h"
#include "socket.h"
#include "in.h"

static int hassysname;
static struct utsname sysname;
int h_errno;

struct hostent *
gethostbyaddr(host)
struct sockaddr *host;
{
	static struct hostent hent;
	static struct sockaddr_in inaddr;

	if (!hassysname) {
		if (uname(&sysname) == -1)
			return NULL;
		hassysname = 1;
	}
	/*
	 * Here, the host name must match the current host
	 * for the function to work.
	 * As an alternative, we can map all host names
	 * to the current host.
	 */
#if 0
	if (strcmp(host, sysname.nodename) == 0) {
#endif
		hent.h_name = sysname.nodename;
		hent.h_aliases = NULL;
		hent.h_addrtype = AF_INET;
		hent.h_length = 1;
		hent.h_addr = &inaddr;
		inaddr.sin_family = AF_INET;
		inaddr.sin_port = 0;
		inaddr.sin_addr.s_addr = 0;
		return &hent;
#if 0
	} else {
		h_errno = HOST_NOT_FOUND;
		return NULL;
	}
#endif
}
