/*
 * Socket structure used internally in the socket emulation package
 */

struct socket {
	short	so_options;		/* from socket call, see socket.h */
	short	so_state;		/* internal state flags SS_*, below */
	char	so_type;		/* socket type */
	short	so_fd;			/* socket file descriptor */
	char	*so_name;		/* Name of socket pipe */
	struct sockaddr *so_addr;	/* Address of socket */
	long	so_domain;
	short	so_protocol;
	/*
	 * the following variables set for a connected socket
	 */
	short	so_rfd;			/* Read-side file descriptor */
	short	so_wfd;			/* write-side file descriptor */
	short	so_pfd;			/* Peer socket file descriptor */
	char	*so_rname;		/* Read-side-pipe filename */
	char	*so_wname;		/* Write-side-pipe filename */
	struct sockaddr *so_conn;	/* Address of connected socket */
};

/*
 * Socket state bits.
 */
#define	SS_ISCONNECTED		0x002	/* socket connected to a peer */
#define	SS_NBIO			0x100	/* non-blocking ops */

/*
 * Message send through the main socket channel
 */
struct socket_packet {
	unsigned short	scm_magic;	/* Magic number */
	char	scm_msg;		/* Socket message */
	char	scm_type;		/* socket type */
	char	scm_rname[14];		/* name of "read" pipe */
	char	scm_wname[14];		/* name of "write" pipe */
	union {				/* Callers address */
		struct sockaddr sa;
		struct sockaddr_in in;
		struct sockaddr_un un;
	} scm_addr;
};

#define	SOCKET_MAGIC	0xc561

/*
 * Socket message types
 */
#define	MSG_CONNECT	1		/* Want to connect to socket */
#define	MSG_CONNECT_OK	2		/* Connect ok message */
#define	MSG_FAIL	3		/* General failure message */
#define	MSG_DISCONNECT	4		/* Disconnection message */

extern struct socket *_socktab[];
extern fd_set _socketmap;
#define	GETSOCKET(sofd)	((sofd)>=0 && (sofd)<=FD_SETSIZE ? _socktab[sofd] : NULL)

/*
 * Internal routines in the socket package
 */
int _setsolock();
int _clearsolock();
int _checksolock();
char *_socketname();
int _sodisconnect();
int _sodisconnect2();
