#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

int
getsockopt(s, level, name, val, avalsize)
int s, level, name, *val, *avalsize;
{
	struct socket *so;

	if ((so = GETSOCKET(s)) == NULL)
		return -1;
	if (level != SOL_SOCKET) {
		errno = ENOPROTOOPT;
		return -1;
	}
	switch (name) {
	case SO_LINGER:
	case SO_USELOOPBACK:
	case SO_DONTROUTE:
	case SO_DEBUG:
	case SO_KEEPALIVE:
	case SO_REUSEADDR:
	case SO_BROADCAST:
	case SO_OOBINLINE:
		*val = so->so_options & name;
		*avalsize = sizeof(so->so_options);
		break;

	case SO_TYPE:
		*val = so->so_type;
		*avalsize = sizeof(so->so_type);
		break;

	case SO_ERROR:
		*val = 0;
		*avalsize = sizeof(int);
		break;

	case SO_SNDBUF:
	case SO_RCVBUF:
	case SO_SNDLOWAT:
	case SO_RCVLOWAT:
	case SO_SNDTIMEO:
	case SO_RCVTIMEO:
		*val = 0;
		*avalsize = sizeof(int);
		break;

	default:
		errno = ENOPROTOOPT;
		return -1;
	}
	return 0;
}
