#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

/*
 * Get name of peer for connected socket.
 */
int
getpeername(fdes, asa, alen)
int fdes, *alen;
struct sockaddr *asa;
{
	register struct socket *so;
	int len;

	if ((so = GETSOCKET(fdes)) == NULL)
		return -1;
	if (so->so_conn) {
		len = so->so_conn->sa_family == AF_UNIX
			? strlen(((struct sockaddr_un *)so->so_conn)->sun_path)
				+ 1 + sizeof(short)
			: sizeof(struct sockaddr);
		*alen = len;
		memcpy((char *)asa, (char *)so->so_conn, len);
	} else
		*alen = 0;
	return 0;
}
