#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <memory.h>
#include <errno.h>
#include <fcntl.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

/*
 * Bind an address to an already defined socket.
 * AF_UNIX sockets can be located anywhere in the file
 * structure. The file according to the pathname is linked to
 * the socket pipe created by socket().
 * AF_INET sockets are simulated by a file in the /usr/spool/socket
 * directory, unique according to the socket number
 * AF_UNSPEC sockets use the original pipe created by socket().
 */
int
bind(sofd, name, namelen)
int sofd, namelen;
struct sockaddr *name;
{
	register struct socket *so;
	char *path;
	int fd, e;

	if ((so = GETSOCKET(sofd)) == NULL)
		return -1;
	if (so->so_state & SS_ISCONNECTED) {
		errno = EADDRINUSE;
		return -1;
	}
	if (so->so_domain != name->sa_family) {
		errno = EPROTOTYPE;
		return -1;
	}
	if (so->so_addr != NULL) {
		errno = EADDRINUSE;
		return -1;
	}
	/*
	 * Create a link to the socket according to the
	 * address given.
	 */
	if (name->sa_family != AF_UNSPEC) {
		path = _socketname(name);
		if (path == NULL) {
			errno = EOPNOTSUPP;
			return -1;
		}
		if (link(so->so_name, path) == -1) {
			if (errno != EEXIST)
				return -1;
			/*
			 * Socket address exists. Check if it is bound
			 * to an active socket, or just "left around"
			 */
			fd = open(path, O_RDWR);
			if (fd == -1)
				return -1;
			e = _checksolock(fd, 0);
			if (e == -1) {
				close(fd);
				return -1;
			}
			if (e) {
				errno = EADDRINUSE;
				close(fd);
				return -1;
			}
			/*
			 * The socked file is free. Delete it, and
			 * try the bind it to the socket again.
			 */
			close(fd);
			unlink(path);
			if (link(so->so_name, path) == -1)
				return -1;
		}
	}
	so->so_addr = (struct sockaddr *)malloc(namelen);
	memcpy((char *)so->so_addr, (char *)name, namelen);
	return 0;
}
