/*

File	: vsprintf.c
Purpose	: Make v*printf calls in Mark Williams C 
	  under Coherent 3.10
Date	: 11/02/92
By	: Noud van Klinken

*/


#include <varargs.h>
/* The varargs.h header is not standard available for Coherent
   But you can download one from piggy.ucsb.edu
*/
#include <stdio.h>


extern va_list vp_frame (fmt, arg_ptr);

/* 
----------------------------------------------------------------------------
  vsprintf workalike function with recursive format
*/


int vsprintf ( ostr, fmt, arg_ptr)
char *ostr;
char *fmt;
va_list arg_ptr;
{
   va_list new_ptr;
   int ret;

   new_ptr = vp_frame (fmt, arg_ptr);
   if (!new_ptr)
      return 0;

   ret = sprintf ( ostr, "%r", new_ptr);
   free (new_ptr);
   return ret;
}
