/*

File	: vfprintf.c
Purpose	: Make v*printf calls in Mark Williams C 
	  under Coherent 3.10
Date	: 11/02/92
By	: Noud van Klinken

*/


#include <varargs.h>
/* The varargs.h header is not standard available for Coherent
   But you can download one from piggy.ucsb.edu
*/
#include <stdio.h>


extern va_list vp_frame (fmt, arg_ptr);

/* 
----------------------------------------------------------------------------
  vfprintf workalike function with recursive format
*/


int vfprintf ( ofp, fmt, arg_ptr)
FILE *ofp;
char *fmt;
va_list arg_ptr;
{
   va_list new_ptr;
   int ret;

   new_ptr = vp_frame (fmt, arg_ptr);
   if (!new_ptr)
      return 0;

   ret = fprintf ( ofp, "%r", new_ptr);
   free (new_ptr);
   return ret;
}
