.TH IDENT L "October 30, 1989" "Purdue University"
.SH NAME
ident \- identify files
.SH SYNOPSIS
\fBident\fR [ \fB\-q\fR ] [ file ... ]
.SH DESCRIPTION
.I Ident
searches the named files or, if no file name appears, the standard input
for all occurrences of the pattern
\fI$keyword:...$\fR, where \fIkeyword\fR is one of
.nf

        Author
        Date
        Header
        Id
        Locker
        Log
        Revision
        RCSfile
        Source
        State

.fi
These patterns are normally inserted automatically by the RCS command
.IR co (L),
but can also be inserted manually. The option \fB\-q\fR suppresses
the warning given if there are no patterns in a file.
.PP
\fIIdent\fR works on text files as well as object files and dumps.
For example, if the C program in file f.c contains
.nf

        char rcsid[] = "$\&Header:  Header information $";

.fi
and f.c is compiled into f.o, then the command
.nf

        ident  f.c  f.o

will print

        f.c:
                $\&Header:  Header information $
        f.o:
                $\&Header:  Header information $

.SH IDENTIFICATION
.de VL
\\$2
..
Author: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907.
.sp 0
Revision Number:
.VL $Revision: 1.3 $
; Release Date:
.VL $Date: 89/10/30 17:36:36 $
\&.
.sp 0
Copyright \(co 1982, 1988, 1989 by Walter F. Tichy.
.SH SEE ALSO
ci(L), co(L), rcs(L), rcsdiff(L), rcsintro(L), rcsmerge(L), rlog(L), rcsfile(L),
.sp 0
Walter F. Tichy, "Design, Implementation, and Evaluation of a Revision Control
System," in \fIProceedings of the 6th International Conference on Software
Engineering\fR, IEEE, Tokyo, Sept. 1982.
