.TH CO L "October 30, 1989" "Purdue University"
.SH NAME
co \- check out RCS revisions
.SH SYNOPSIS
.B co
[ options ]
file ...
.SH DESCRIPTION
.I Co
retrieves a revision from each RCS file and stores it into
the corresponding working file.
Each file name ending in `,v' is taken to be an RCS file;
all other files are assumed to be working files.
If only a working file is given, \fIco\fR tries to find the corresponding
RCS file in the directory ./RCS and then in the current directory.
For more details, see the file naming section below.
.PP
Revisions of an RCS file may be checked out locked or unlocked. Locking a
revision prevents overlapping updates. A revision checked out for reading or
processing (e.g., compiling) need not be locked. A revision checked out
for editing and later checkin must normally be locked. \fICo\fR with locking
fails if the revision to be checked out is currently locked by another user.
(A lock may be broken with the
.IR rcs (L)
command.)
\fICo\fR with locking also requires the caller to be on the access list of
the RCS file, unless he is the owner of the
file or the superuser, or the access list is empty.
\fICo\fR without locking is not subject to accesslist restrictions, and is
not affected by the presence of locks.
.PP
A revision is selected by options for revision or branch number,
checkin date/time, author, or state.
When the selection options
are applied in combination, \fIco\fR retrieves the latest revision
that satisfies all of them.
If none of the selection options
is specified, \fIco\fR retrieves the latest revision
on the default branch (normally the trunk, see the
.B \-b
option of
.IR rcs (L)).
A revision or branch number may be attached
to any of the options
\fB\-f\fR, \fB\-l\fR, \fB\-p\fR, \fB\-q\fR, \fB\-r\fR, or \fB\-u\fR.
The options \fB\-d\fR (date), \fB\-s\fR (state), and \fB\-w\fR (author)
retrieve from a single branch, the \fIselected\fR branch,
which is either specified by one of
\fB\-f\fR,..., \fB\-u\fR, or the default branch.
.PP
A \fIco\fR command applied to an RCS
file with no revisions creates a zero-length working file.
\fICo\fR always performs keyword substitution (see below).
.PP
.TP 11
.BR \-r [\fIrev\fR]
retrieves the latest revision whose number is less than or equal to \fIrev\fR.
If \fIrev\fR indicates a branch rather than a revision,
the latest revision on that branch is retrieved.
If \fIrev\fR is omitted, the latest revision on the default branch
(see the
.B \-b
option of
.IR rcs (L))
is retrieved.
\fIRev\fR is composed of one or more numeric or symbolic fields
separated by `.'. The numeric equivalent of a symbolic field
is specified with the \fB\-n\fR option of the commands
.IR ci (L)
and
.IR rcs (L).
.TP 11
.BR \-l [\fIrev\fR]
same as \fB\-r\fR, except that it also locks the retrieved revision for
the caller.  See option \fB\-r\fR for handling of the revision number
.I rev .
.TP 11
.BR \-u [\fIrev\fR]
same as \fB\-r\fR, except that it unlocks the retrieved revision (if it was
locked by the caller). If \fIrev\fR is omitted, \fB\-u\fR
retrieves the latest revision locked by the caller; if no such lock exists,
it retrieves the latest revision on the default branch.
.TP 11
.BR \-f [\fIrev\fR]
forces the overwriting of the working file;
useful in connection with \fB\-q\fR.
See also the section on file modes below.
.TP 11
.BR \-p [\fIrev\fR]
prints the retrieved revision on the standard output rather than storing it
in the working file.
This option is useful when \fIco\fR
is part of a pipe.
.TP 11
.BR \-q [\fIrev\fR]
quiet mode; diagnostics are not printed.
.TP 11
.BI \-d "date"
retrieves the latest revision on the selected branch whose checkin date/time is less than or equal to \fIdate\fR.
The date and time may be given in free format and are converted to local time.
Examples of formats for \fIdate\fR:
.ne 5
.nf

\fI22-April-1982, 17:20-CDT,
2:25 AM, Dec. 29, 1983,
Tue-PDT, 1981, 4pm Jul 21\fR         \fR(free format),
\fIFri, April 16 15:52:25 EST 1982 \fR(output of ctime).
.fi

Most fields in the date and time may be defaulted.
\fICo\fR determines the defaults in the order year, month, day,
hour, minute, and second (most to least significant). At least one of these
fields must be provided. For omitted fields that are of higher significance
than the highest provided field,
the current values are assumed. For all other omitted fields,
the lowest possible values are assumed.
For example, the date "20, 10:30" defaults to
10:30:00 of the 20th of the current month and current year.
The date/time must be quoted if it contains spaces.
.TP 11
.BI \-s "state"
retrieves the latest revision on the selected branch whose state is set to \fIstate\fR.
.TP 11
.BR \-w [\fIlogin\fR]
retrieves the latest revision on the selected branch which was checked in
by the user with login name \fIlogin\fR. If the argument \fIlogin\fR is
omitted, the caller's login is assumed.
.TP 11
.BI \-j joinlist
generates a new revision which is the join of the revisions on \fIjoinlist\fR.
\fIJoinlist\fR is a comma-separated list of pairs of the form
\fIrev2:rev3\fR, where \fIrev2\fR and \fIrev3\fR are (symbolic or numeric)
revision numbers.
For the initial such pair, \fIrev1\fR denotes the revision selected
by the above options \fB\-r\fR, ..., \fB\-w\fR. For all other pairs, \fIrev1\fR
denotes the revision generated by the previous pair. (Thus, the output
of one join becomes the input to the next.)

For each pair, \fIco\fR joins revisions \fIrev1\fR and \fIrev3\fR
with respect to \fIrev2\fR.
This means that all changes that transform
\fIrev2\fR into \fIrev1\fR are applied to a copy of \fIrev3\fR.
This is particularly useful if \fIrev1\fR
and \fIrev3\fR are the ends of two branches that have \fIrev2\fR as a common
ancestor. If \fIrev1\fR < \fIrev2\fR < \fIrev3\fR on the same branch,
joining generates a new revision which is like \fIrev3\fR, but with all
changes that lead from \fIrev1\fR to \fIrev2\fR undone.
If changes from \fIrev2\fR to \fIrev1\fR overlap with changes from
\fIrev2\fR to \fIrev3\fR, \fIco\fR prints a warning and includes the
overlapping sections, delimited by the lines \fI<<<<<<<\ rev1,
=======\fR, and \fI>>>>>>>\ rev3\fR.

For the initial pair, \fIrev2\fR may be omitted. The default is the common
ancestor.
If any of the arguments indicate branches, the latest revisions
on those branches are assumed.
The options \fB\-l\fR and \fB\-u\fR lock or unlock \fIrev1\fR.
.SH "KEYWORD SUBSTITUTION"
Strings of the form \fI$keyword$\fR and \fI$keyword:...$\fR embedded in
the text are replaced
with strings of the form \fI$keyword:\ value\ $\fR,
where \fIkeyword\fR and \fIvalue\fR are pairs listed below.
Keywords may be embedded in literal strings
or comments to identify a revision.
.PP
Initially, the user enters strings of the form \fI$keyword$\fR.
On checkout, \fIco\fR replaces these strings with strings of the form
\fI$keyword:\ value\ $\fR. If a revision containing strings of the latter form
is checked back in, the value fields will be replaced during the next
checkout.
Thus, the keyword values are automatically updated on checkout.
.PP
Keywords and their corresponding values:
.TP 13
$\&Author$
The login name of the user who checked in the revision.
.TP
$\&Date$
The date and time the revision was checked in.
.TP
$\&Header$
A standard header containing the full pathname of the RCS file, the
revision number, the date, the author, the state, and the locker (if locked).
.TP
$\&Id$
Same as $\&Header$, except that the RCS file name is without a path.
.TP
$\&Locker$
The login name of the user who locked the revision (empty if not locked).
.TP
$\&Log$
The log message supplied during checkin, preceded by a header
containing the RCS file name, the revision number, the author, and the date.
Existing log messages are NOT replaced.
Instead, the new log message is inserted after \fI$\&Log:...$\fR.
This is useful for
accumulating a complete change log in a source file.
.TP
$\&RCSfile$
The name of the RCS file without path.
.TP
$\&Revision$
The revision number assigned to the revision.
.TP
$\&Source$
The full pathname of the RCS file.
.TP
$\&State$
The state assigned to the revision with the
.B \-s
option of
.IR rcs (L)
or
.IR ci (L).
.TP
.SH "FILE NAMING"
Pairs of RCS files and working files may be specified in 3 ways (see also the
example section).
.PP
1) Both the RCS file and the working file are given. The RCS file name is of
the form \fIpath1/workfile,v\fR
and the working file name is of the form
\fIpath2/workfile\fR, where
\fIpath1/\fR and
\fIpath2/\fR are (possibly different or empty) paths and
\fIworkfile\fR is a file name.
.PP
2) Only the RCS file is given. Then the working file is created in the current
directory and its name is derived from the name of the RCS file
by removing \fIpath1/\fR and the suffix \fI,v\fR.
.PP
3) Only the working file is given.
Then \fIco\fR looks for an RCS file of the form
\fIpath2/RCS/workfile,v\fR or \fIpath2/workfile,v\fR (in this order).
.PP
If the RCS file is specified without a path in 1) and 2), then \fIco\fR
looks for the RCS file first in the directory ./RCS and then in the current
directory.
.SH EXAMPLES
Suppose the current directory contains a subdirectory `RCS' with an RCS file
`io.c,v'. Then all of the following commands retrieve the latest
revision from `RCS/io.c,v' and store it into `io.c'.
.nf
.sp
	co  io.c;    co  RCS/io.c,v;   co  io.c,v;
	co  io.c  RCS/io.c,v;    co  io.c  io.c,v;
	co  RCS/io.c,v  io.c;    co  io.c,v  io.c;
.fi
.SH "FILE MODES"
The working file inherits the read and execute permissions from the RCS
file. In addition, the owner write permission is turned on, unless the file
is checked out unlocked and locking is set to \fIstrict\fR (see
.IR rcs (L)).
.PP
If a file with the name of the working file exists already and has write
permission, \fIco\fR aborts the checkout if \fB\-q\fR is given, or asks
whether to abort if \fB\-q\fR is not given. If the existing working file is
not writable or \fB\-f\fR is given, the working file is deleted without asking.
.SH FILES
The caller of the command must have write permission in the working
directory, read permission for the RCS file, and either read permission
(for reading) or read/write permission (for locking) in the directory which
contains the RCS file.
.PP
A number of temporary files are created.
A semaphore file is created in the directory of the RCS file
to prevent simultaneous update.
.SH DIAGNOSTICS
The RCS file name, the working file name,
and the revision number retrieved are
written to the diagnostic output.
The exit status always refers to the last file checked out,
and is 0 if the operation was successful, 1 otherwise.
.SH IDENTIFICATION
.de VL
\\$2
..
Author: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907.
.sp 0
Revision Number:
.VL $Revision: 1.5 $
; Release Date:
.VL $Date: 89/10/30 17:36:34 $
\&.
.sp 0
Copyright \(co 1982, 1988, 1989 by Walter F. Tichy.
.SH SEE ALSO
ci(L), ident(L), rcs(L), rcsdiff(L), rcsintro(L), rcsmerge(L), rlog(L),
rcsfile(L)
.sp 0
Walter F. Tichy, "Design, Implementation, and Evaluation of a Revision Control
System," in \fIProceedings of the 6th International Conference on Software
Engineering\fR, IEEE, Tokyo, Sept. 1982.
.SH LIMITATIONS
The option \fB\-d\fR gets confused in some circumstances,
and accepts no date before 1970.
Links to the RCS and working files are not preserved.
There is no way to suppress the expansion of keywords, except
by writing them differently. In nroff and troff, this is done by embedding the
null-character `\\&' into the keyword.
.SH BUGS
The option \fB\-j\fR does not work for
files that contain lines with a single `.'.
