/* SCREEN.C - PCLIST: A fast, keypad driven listing utility.  Version 2.0.7 */

#include "pclist.h"

/* STRMOV - Place string q within string p with no terminating \0.
 */
void strmov (p, q)
char *p, *q;
{
	while (*q)
		*p++ = *q++;
}

/* CLS -- 	Clear the screen (window); if mode is nonzero, Add the header 
 *			  in standout mode.  Cur_line is a string pointer for Header info.
 */
void cls(mode, cur_line)
int mode;
char *cur_line;
{
	wclear (swin);
	wmove (swin, Hdr_line, 0);

	if (mode) {
		strmov (header+8, cur_line);
		wstandout (swin);
		waddstr (swin, header);
		wstandend (swin);
	}
}

/* RESET_HDRS --	Reset the File List Header and Trailer, so
 *						disp_xxx () works properly.
 */
reset_hdrs (name, type, trlr)
char *name, *type, *trlr;
{
	int i, l;

	for (i = 0; i < 80; i++)				/* So header can be anything */
		header[i] = ' ';
	header[79] = '\0';
	strmov (header, "PCLIST:");
	l = strlen (name);
	strmov (header + 78 - l, name);		/* Change Global trailer lines */
	strmov (header + 72 - l, type);		/*   to suit your terminal.	 */
	standout ();
	mvaddstr (Trlr_line, 0, trlr);		/* Add the bottom line. */
	standend ();
	refresh ();									/* Make Bottom Line show */
}

/* DISP_FILE_SCR --	Display a screen-full of lines, beginning with
 *							line l, shifted left sh char's from file fp.
 */
int disp_file_scr (l, fp, sh)
int l, sh;
FILE *fp;
{
	int i, j;
	char c, info[60], *p;
	
	while ((l + Text_lines) > last_line && !(end_of_file | early_end))
			last_line = fill_buf (last_line, Text_lines, fp);
#ifdef HDB
	dbf = fopen ("list-db", "a");
	fprintf (dbf, 
		"disp_file_scr-1: Last_line %d, blk_no %d, buf_p %4x ,buf_size %ld\n",
		last_line, buf_blk_no, buf_p ,buf_size);
	fclose (dbf);
#endif
	sprintf (info, "Line: %d, Last: %d%s Buf: %ld   ",
				l, last_line-2, end_of_file ? "," : "(?),", early_end ?
				buf_size - waste_buf : buf_size - (buf_end - buf_p) - waste_buf);
	cls (1, info);

		/* Avoid displaying Object, Executable or Archive Modules */
	if ( (*(l_ndx[1].bufp) == 0x07 && *(l_ndx[1].bufp+1) == 0x01) ||
		  (*(l_ndx[1].bufp) == 0x5D && *(l_ndx[1].bufp+1) == 0xFF) )  {
		mvwaddstr (swin, 12, 5, exec_err_msg_1);
		wrefresh (swin);
		return 1;			/* So caller can see it, too */
	}
	for (i = Top_text_line; i <= Text_lines; i++)  {
		if ((j = i - 1 + l) == H_L_line_no)
			wstandout (swin);
		if (strlen (p = (j < last_line) ? l_ndx[j].bufp : " ") <= 80+sh)
				mvwaddstr (swin, i, 0, (strlen (p) <= sh) ? " " : p+sh);
		else  {
			c = *(p+80+sh);  *(p+80+sh) = '\0';		/* Chop to 80 char's */
			mvwaddstr (swin, i, 0, p+sh);
			*(p+80+sh) = c;								/* - and put it back */
		}
		if (j == H_L_line_no)
			wstandend (swin);
	}
	wmove (swin, 0, 79);
	wrefresh (swin);					/* Make it all show     */

#ifdef HDB
	dbf = fopen ("list-db", "a");
	fprintf (dbf, 
		"disp_file_scr-2: Last_line %d, blk_no %d, buf_p %4x ,buf_size %ld\n",
		last_line, buf_blk_no, buf_p ,buf_size);
	fclose (dbf);
#endif	
			/* Sneak in some reads, while the user peruses */
	if (!(end_of_file | early_end))
			last_line = fill_buf (last_line, 200, fp);
#ifdef HDB
	dbf = fopen ("list-db", "a");
	fprintf (dbf, 
		"disp_file_scr-3: Last_line %d, blk_no %d, buf_p %4x ,buf_size %ld\n",
		last_line, buf_blk_no, buf_p ,buf_size);
	fclose (dbf);
#endif
	return 0;
}

/* DISP_DIR_SCR --	Display a Screen full of directory & file names & sizes,
 *							beginning with item_no, highlighting H_L_item_no from
 *							array using nd directory names, and nt total names.
 */
disp_dir_scr (array, item_no, H_L_item_no, nt, nd)
struct AE **array;
int  item_no, H_L_item_no, nt, nd;
{
	int i, j, p, q, no, cols[3] = { 1, 28, 55 };
	char info[60], *fmt;
	
	sprintf (info, "File: %d   ", H_L_item_no);
	cls (1, info);

	for (i = Top_text_line; i <= Text_lines; i++)  {
		for (j = 0; j < 3; j++)  {
			no = (j * Text_lines) + i - Top_text_line + item_no;
			if (no < nt)  {
				wmove (swin, i, cols[j]);
				if (no == H_L_item_no)  {
					wstandout (swin);
					p = i;  q = cols[j];
				}
				fmt = (no < nd) ? "[%14s] %6ld" : " %14s  %6ld";
				wprintw (swin, fmt, array[no]->name, array[no]->size);
				if (no == H_L_item_no)
					wstandend (swin);
			}
		}
	}
	wmove (swin, p, q);			/* Park the cursor on the selected item */
	wrefresh (swin);				/* Make it all show	*/		
}
