/* PCLIST.H - PCLIST: A fast, keypad driven listing utility.  Version 2.0.7 */

/* Do the Includes for everybody */
#include <stdio.h>
#include <ctype.h>
#include <curses.h>
#include <sys/stat.h>
#include <sys/dir.h>

#define Hdr_line			0		/* Define the Curses Screen Lines */
#define Trlr_line			23
#define Top_text_line	1
#define Bot_text_line	22
#define Text_lines		22
#define Pat_len			80		/* Max length of find pattern */

#define BLOCK_SIZE 2048			/* Get Buffer Space in 2k increments */
#define BLOCK_NO   33			/* Therefore, 32 (+1) max blocks!	 */
#define LINE_MAX	 1500			/* I figure about 22 chars per listing line? */
#define MAX_SHIFT	 180			/* Maximum Left Shift for file display */

#define	P_PAD			 0x0400				/* H-O bit to define Keypad keys */
#define	P_HOME		(0x0047 | P_PAD)
#define	P_UP			(0x0048 | P_PAD)
#define	P_PGUP		(0x0049 | P_PAD)
#define	P_LEFT		(0x004B | P_PAD)
#define	P_CENTER		(0x004C | P_PAD)	/* With the right keyboards! */
#define	P_RIGHT		(0x004D | P_PAD)
#define	P_END			(0x004F | P_PAD)
#define	P_DOWN		(0x0050 | P_PAD)
#define	P_PGDN		(0x0051 | P_PAD)

typedef struct l_indx  {		/* For reference to file lines	*/
	unsigned char *bufp;			/* Pointer to text in memory 				*/
/*	int	line_no;	*/				/* Useful for when I allow larger than */
/*	long	filep;	*/				/* - 64k? source files to be listed.	*/	
}  L_INDX;

struct AE  {						/* For storing, sorting Directory entries */
	long int size;
	char name[];
};

extern WINDOW *swin;							/* Global Subwindow, for text */
extern WINDOW *fwin;							/* Global Subwindow, for find */
extern WINDOW *hwin;							/* Global Subwindow, for help */
extern L_INDX *l_ndx;						/* Global line headers			*/
extern int buf_blk_no;						/* Global Buffer Block Index	*/
extern char *buf_list[];					/* Global Buffer Block List	*/
extern char *buf, *buf_p;					/* Global buffer pointers		*/
extern char *buf_end;						/* Global Buffer End Pointer	*/
extern long int buf_size;					/* Global Buffer Available		*/
extern int waste_buf;						/* Keep track of Wasted buf space */

extern FILE *fp, *dfp;						/* Global file, directory ptr's	 */
extern int end_of_file;						/* Global end-of-file Indicator   */
extern int early_end;						/* Global File-wont-fit Indicator */
extern int last_line;						/* Global Last line No (so far)   */
extern int exit_switch;						/* Global Leave Quickly, properly */
extern int have_pat_sw;						/* For Again, I got a pattern!	 */
extern int H_L_line_no;						/* For Find, "THE" line (0 = none) */
extern int tab_size;							/* Set it as you like it, see main */

extern char pattern[];						/* Buf for Find Pattern			*/
extern char header[];						/* Header - Once per file		*/
extern char *file_trailer;					/* Trailer - For sale or rent	*/
extern char *dir_trailer;					/* Trailer - Ditto, Dir Screen */
extern char *exit_msg;						/* Global exit error message		 */
extern char *exec_err_msg_1;				/* Object, Exec or Archive file   */
extern char *exec_err_msg_2;				/* Can't open that File  */
extern char *exec_err_msg_3;				/* Can't open that Dir   */

/* Functions in PCLIST.C */
extern void leave ();
extern reset_hdrs ();
extern void disp_file ();
extern void disp_dir ();
int main ();

/* Functions in BUF.C */
extern void free_buf ();
extern char *buf_block ();
extern void init_buf ();

/* Functions in DIR-IO.C */
extern int opendir ();
extern int closedir ();
extern struct direct *readdir ();

/* Functions in FIND.C */
extern void process_pattern ();
extern void get_find_pattern ();
extern int do_find ();

/* Functions in HELP*.C */
extern void help_scr ();

/* Functions in INPUT.C */
extern int detab ();
extern int fill_buf ();
extern int getakey ();
extern int compare ();
extern int read_dir_file ();

/* Functions in SCREEN.C */
extern void strmov ();
extern void cls();
extern int disp_file_scr ();
extern disp_dir_scr ();
