/* INPUT.C - PCLIST: A fast, keypad driven listing utility.  Version 2.0.7 */

#include "pclist.h"

/*	DETAB -- Read input from fp into *bfp, expanding tabs as we go, to next
 *				newline or EOF.  If EOF, the global 'end_of_file' is set. Return
 *				the number of characters added to *bfp (including terminating 0),
 *				(No \n's stored)!
 */
#define tabpos(c,t) ((c) % (t) ? 0 : 1)	/* is  col == tabpos ?  */

int detab (bfp, no, fp, tabsize)
char *bfp;				/* Buffer pointer */
int no, tabsize;		/* Buffer Size, User Tabsize */
FILE *fp;
{
	register int c;  int col = 0;
	
	while ((c = fgetc (fp)) != EOF && col < no)  {
		if (c == '\t')
			while (1)  {		/* Till break */
				*bfp++ = ' ';
				++col;
				if (tabpos (col, tabsize))
					break;
			}
		else if (c ==0x01  || c == 0x07 || c == 0x08 || c == 0xFF )  {
			*bfp++ = c;						/* To recognize Obj. & Archives */
			++col;
		}
		else if (c < ' ' || c > '~')  {	/* Including '\n' ! 				*/
			*bfp++ = '\0';						/* NULL terminate, no Control */
			return ++col;						/*  Char's or char's > '~'		*/
		}
		else  {
			*bfp++ = c;
			++col;
		}
	}
	if (col < no)
		end_of_file = 1;
	*bfp++ = '\0';		/* for Insurance */
	return ++col;
}
#undef tabpos

/*	FILL_BUF -- Reads input (via DETAB) and fills the structure entries for
 *					lines input.  Returns the next available line number.
 */
int fill_buf (l, how_many, fp)
int l, how_many;
FILE *fp;
{
	char bf[256];		/* Temporary internal buffer */
	int l_max = l + how_many, nc;
	
	while (l < LINE_MAX && l < l_max && !(end_of_file | early_end))  {
/*		l_ndx[l].filep = ftell (fp);	*/
/*		l_ndx[l].line_no = l; 			*/
		nc = detab (bf, 256, fp, tab_size);
		if (nc > (buf_end - buf_p))  {			/* Out of this block? */
			waste_buf += buf_end - buf_p;
			if ((buf_p = buf_block (BLOCK_SIZE)) == NULL)  {
				early_end = 1;							/* Out of space ! */
				continue;
			}
		}
		strcpy (buf_p, bf);
		l_ndx[l++].bufp = buf_p;
		buf_p += nc;
	}
#ifdef HDB
	dbf = fopen ("list-db", "a");
	fprintf (dbf, "Fill_buf: blk_no %d, buf %4x ,buf_size %ld, waste %d\n",
				buf_blk_no, buf ,buf_size, waste_buf);
	fclose (dbf);
#endif
	return l;
}

/* GETAKEY  -- Read in a key, do standard keyboard preprocessing, convert 
 * 				the keys to the internal character set - as defined below.
 */
#define	ESC			 0x001B				/* For getakey to find ESC's     */

int getakey ()  {
	register int c;

	noecho (); nonl ();		/* so we can get any keystroke */
	for( ; ; ) {
		if ((c = getch ()) == ESC) {		/* Apply ESC prefix	*/
			if ((c = getch ()) == '[') {	/* Arrow keys.		*/
				switch ((c = getch ())) {
					case 'A':
						return (P_UP);					/* UP Arrow */
					case 'B':
						return (P_DOWN);				/* DOWN Arrow */
					case 'C':
						return (P_RIGHT);				/* RIGHT Arrow */
					case 'D':
						return (P_LEFT);				/* LEFT Arrow */
					case 'H':
						return (P_HOME);				/* HOME key */
					case 'U':
						return (P_PGDN);				/* PGDN key */
					case 'V':
						return (P_PGUP);				/* PGUP key */
					case '2':
						switch (getch ()) {
							case '4': 
								if ((getch ()) == 'H')
									return (P_END);		/* END key */
								continue;
						}
				}		/* switch */
				continue;
			}		/* if ( '[' ) */
			if (c == '7') {	
				return (P_CENTER);				/* Center keypad key */
			}
			continue;
		}		/* if ( ESC ) */
		break;
	}
	echo (); nl ();			/* restore in case of crash!   */
	return (c);
}
#undef ESC			/* To avoid conflicts with include files?? */

/* COMPARE --	Directory entry name comparison function for Shellsort
 */
compare (s1, s2)
register struct AE **s1, **s2;
{
	extern int strcmp ();
	
	return (strcmp ((*s1)->name, (*s2)->name));
}

/* READ_DIR_FILE --	Read, categorize and sort a Directory's
 *							contents prior to Directory Display.
 */
int read_dir_file (d_name, array, buf, nt, nd, nf)
char *d_name, *buf;
struct AE **array;
int *nt, *nd, *nf;
{
	int fd, i;
	extern int opendir (), closedir ();
	extern struct direct *readdir ();
	struct direct de;
	struct stat sbf;
	char *buf_p;

	buf_p = buf;
	if ((fd = opendir (d_name)) == -1)  {
		cls (0, NULL);			/* Handle the Can't Open that Directory problem */
		mvwaddstr (swin, 12, 20, exec_err_msg_3);
		wrefresh (swin);
		getakey ();
		return 1;				/* So caller can see it, too. */
	}
	
	while (readdir (fd, &de) != NULL)  {
		if ((de.d_ino == 0) ||						/* Slot not in use */
			(strcmp (de.d_name, ".") == 0) ||	/* We are already here */
			(strcmp (de.d_name, "..") == 0) ||	/* Ignore parent Dir.  */
			(stat (de.d_name, &sbf)))				/* if we can't stat, stuff it */
			continue;
		if ((sbf.st_mode & S_IFMT) == S_IFDIR)  {
			array[(*nt)++] = array[*nd];			/* Swap 1st file entry to here */
			array[(*nd)++] = buf_p;					/* put dir entry there			 */
		}
		else
			array[(*nt)++] = buf_p;					/* Put file entry at end */

		*((long *) buf_p)++ = sbf.st_size;				/* Get the size, */
		for (i = 0; de.d_name && i < DIRSIZ; i++)
			*buf_p++ = de.d_name[i];						/* and the name. */
		*buf_p++ = '\0';
	}

	*nf = *nt - *nd;
	if (*nd > 0)
		shellsort (array, *nd, sizeof (struct AE *), compare);
	if (*nf > 0)
		shellsort (array + *nd, *nf, sizeof (struct AE *), compare);

	if (closedir (fd))  {
		exit_msg = "Read_dir_file: Can't Close Directory '%s'!\n";
		leave (1, d_name);
	}
	return 0;
}
