/* DIR-IO.C - PCLIST: Functions to implement call-level directory input. 
 *
 *		Functions Defined:	
 *			int opendir (char * dname) 		Open Directory for later use.
 *			int closedir (int fd)      		Close an open Directory
 *			struct direct *readdir (int fd)	Read next Directory Entry.
 */

#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <errno.h>
#ifndef NULL
#define NULL  ((char *)0)
#endif

/* Include the following declarations in your program before use!: 

	#include <sys/dir.h>
	int opendir ();
	int closedir ();
	struct direct *readdir ();

 *	If not declared, the readdir () function cannot return a struct  */

/* OPENDIR ()
 * Open the named directory as a file for reading by readdir ()
 *	int opendir (dname)  char *dname;
 *
 *	Opens the file specified by  dname  and checks that it is a directory
 *	file; if successful, returns the integer file descriptor number; if in
 *	error, sets  errno  and returns -1.
 */
int opendir (dname)
char *dname;
{
	int fd;
	struct stat stbuf;
	
	if (stat (dname, &stbuf) == -1)
		{ errno = ENOENT; return -1; }
	if ((stbuf.st_mode & S_IFMT) != S_IFDIR)
		{ errno = ENOTDIR; return -1; }
	if ((fd = open (dname, O_RDONLY)) == -1)
		{ errno = EIO; return -1; }
	return fd;
}

/* CLOSEDIR ()
 * Close the directory specified by an integer file descriptor.
 *	int closedir (fd)  int fd;
 *
 *	Close the directory file specified by  fd ; if successful, return 0;
 *	else sets  errno  and returns -1.
 */
int closedir (fd)
int fd;
{
	if (fd == -1)
		{ errno = EBADF; return -1; }
	return (close (fd));
}

/* READDIR ()
 * Read the next entry from a directory file and return the buffer address.
 * #include <sys/stat.h>
 *	struct direct *readdir (fd, bufp)  int fd;  struct direct *bufp;
 *
 *	Reads the next entry from the open directory file specified by the integer
 *	file descriptor  fd, using the buffer provided by the caller whose address
 *	is  bufp.  If successful, returns a pointer to the user's directory buffer
 *	structure; if in error, sets  errno  and returns NULL.
 *
 *	NOTE:::	This routine will read the next directory entry whether or not
 *				it is in use!!  In other words, it is up to the caller to check
 *				bufp -> d_ino for non-zero before really using the entry !!!!!!
 */
struct direct *readdir (fd, bufp)
int fd;
struct direct *bufp;
{
	if (fd < 0)
		{ errno = EBADF; return NULL; }
	if (read (fd, bufp, sizeof (struct direct)) != sizeof (struct direct))
		{ errno = EIO; return NULL; }
	return bufp;
}
