/* BUF.C -- PCLIST: A fast, keypad driven listing utility.  Version 2.0.7 */

#include "pclist.h"

/* FREE_BUF -- Free up the Buffer System allocations.
 */
void free_buf ()  {
	free (l_ndx);
	while (--buf_blk_no >= 0)  {
		free (buf_list[buf_blk_no]);
		buf_list[buf_blk_no] = NULL;
	}
}

/* BUF_BLOCK -- Allocate memory for a Buffer Block in the Buffer System.
 */
char *buf_block (size)
int size;
{
	size -= 2;
	if ((buf = buf_list[buf_blk_no] = malloc (size)) == NULL)
		return (NULL);
	buf_list[++buf_blk_no] = NULL;		/* Mark next entry MT */
	buf_end = buf + size;
	buf_size += size;							/* For Header line	 */
#ifdef HDB
	dbf = fopen ("list-db", "a");
	fprintf (dbf, "Buf_block: blk_no %d, buf %4x ,buf_size %ld\n",
				buf_blk_no, buf ,buf_size);
	fclose (dbf);
#endif
	return buf;
}

/* INIT_BUF -- Allocate memory for Line-Index list and Buffer System.
 *					Size is size of the line index.
 */
void init_buf (size)
int size;
{
	if ((l_ndx = (L_INDX *) calloc (size, sizeof (L_INDX))) == NULL)  {
		exit_msg = "Insufficient memory for allocation of Line Index!\n";
		leave (1, NULL);
	}
	
	waste_buf = buf_blk_no = buf_size = 0;
	buf_list[0] = NULL;
	if ((buf_p = buf_block (BLOCK_SIZE)) == NULL)  {
		exit_msg = "Insufficient memory for allocation of Buffer Space!\n";
		leave (1, NULL);
	}
	buf_p = buf;	
#ifdef HDB
	dbf = fopen ("list-db", "a");
	fprintf (dbf, "Init_buf: blk_no %d, buf_p %4x\n",
				buf_blk_no, buf_p);
	fclose (dbf);
#endif
}
