#ifdef SCANNER
# define sextern
#else
# define sextern extern
#endif

/*{{{  token-definition*/
typedef enum {
  ERROR,
  BINDNAME,                      /* name of keybinding-definition     */
  ENDFILE,                       /* fileend is reached                */
  BEGIN, END,                    /* ( and ) to group the commandparts */
  DOLLAR,META,CHAR,              /* $ M- C- and " to describe keycode */
  COMMA,                         /* ,                                 */
  KEYALIAS,                      /* define a name for a keysequence   */
  KEYDEF,                        /* define a binding                  */
  DEFOP,                         /* define a new origami-operation    */
  DEFMACRO, INITMACRO,           /* define or init a fix_macro        */
  FORWARD,                       /* declare a later defined macro     */
  VARIABLE,                      /* a defined variable                */
  OPCODE,                        /* a origami-operation               */
  NAME,                          /* a string without "                */
  MACRO,                         /* a string with leading "           */
  OPERATION,                     /* name of a new origami-operation   */
  REPEAT,                        /* next macrooperation is repeated   */
  CASE,
  ESAC,
  DO,
  WHILE,
  IF,
  ELSE,
  FI,
  NOT,
  AND,OR,
  TEST_FILED,
  TEST_FOLD_LINE,
  TEST_BEGIN_FOLD,
  TEST_END_FOLD,
  TEST_TEXT,
  TEST_TOP,
  TEST_BOTTOM,
  TEST_CHAR,
  COUNTER_NULL,
  TEST_BEGIN_LINE,
  TEST_END_LINE,
  SET_COUNTER,
  ADD_COUNTER,
  SUM_COUNTER,
  INV_COUNTER,
  C_POSITIV,
  TEST_BEHIND_COUNTER,
  GOTO_X,
  GOTO_COUNTER,
  STORE_X,
  STORE_Y,
  GOTO_Y,
  EXIT,
  MES_EXIT
} tokens;
/*}}}  */
typedef struct { char *name; tokens value; } keywords;
typedef struct { char *key_name; char *code; } ALIAS;
typedef struct { char *op_name; bool defined; int  length,*ops,place; } OP;
typedef struct { char *var_name; int no; } VARS;
typedef struct { char *name; TOKEN num; } KEY;
sextern char   tk_char;
sextern ALIAS  *tk_alias;
sextern KEY    *tk_key;
sextern OP     *tk_operation;
sextern VARS   *tk_var;
sextern char   tk_string[name_lg];
sextern TOKEN  tk_macro[macro_lg];
sextern ALIAS *func_key[64];
sextern OP *new_op[64];
sextern VARS *vars[128];
sextern int line_no;

#ifdef SCANNER
extern bool verbose;
#else
extern KEY bindings;
extern keywords *keytab;
#endif
