/* keyboard.c - Keyboard interpreter for Origami */

#include <sys/types.h>
#include <sgtty.h>
#include <stdio.h>

static struct sgttyb new,old;

static int keybuff[40];
static int *pointer,*buffered;

void init_keyboard()
{
  gtty(0, &old);
  gtty(0, &new);
  new.sg_flags|=(RAW|CRMOD);
  new.sg_flags&=~(ECHO);
  stty(0, &new);
}

reset_keyboard()
{
  stty(0, &old);
}

int get_key ()
{
int result;
unsigned char ch;

	
	fflush (stdout);

	if (buffered > pointer) 
		return (*pointer++);

	pointer = buffered = keybuff;

	for (result = 1;result == 1;) {
		read (0,&ch,1);
		*buffered = ch;
		result = find_key (*buffered++);
	}

	if (result) {
		buffered = keybuff;
		return (result);
	}
	return (*pointer++);
}

