/* random.c */
/* machine dependent */

/**********************************************************************/
/*                                                                    */
/*           MM   MM  IIIIIII  L        L        EEEEEEE              */
/*           M M M M     I     L        L        E                    */
/*           M  M  M     I     L        L        EEEE                 */
/*           M     M     I     L        L        E                    */
/*           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              */
/*                                                                    */
/*      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          */
/*      B     B  O     O  R     R  N N   N  E        S                */
/*      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           */
/*      B     B  O     O  R    R   N   N N  E              S          */
/*      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           */
/*                                                                    */
/*                                                                    */
/* Creation: Edmond Dujardin                                          */
/*           (c) 1962 Parker Brothers, Inc.                           */
/*                                                                    */
/* Written by: Brett K. Carver                                        */
/*             Hewlett-Packard, 1983.                                 */
/*                                                                    */
/* Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             */
/*                                                                    */
/**********************************************************************/

#include "miles.h"
#include <time.h>

#undef MY_RAND
#undef RND_ONE

/**********************************************************************/
/*                                                                    */
/*              CONSTANTS AND VARIABLES                               */
/*                                                                    */
/**********************************************************************/

/**********************************/
/* external procedure definitions */
/**********************************/

extern	long	time();

/**********************************/
/* external variable definitions */
/**********************************/

extern	struct	tm	*localtime();

#ifdef MY_RAND

/**********************************************************************/
/*                                                                    */
/*              RANDOM NUMBER GENERATION UTILITIES                    */
/*                                                                    */
/**********************************************************************/

#ifdef RND_ONE

double rnd_x = 283463.5;

/**************************************/
/* pseudo random number generator one */
/**************************************/
rnd()
{
rnd_x = (double)((3612 * (long)rnd_x + 5701) % 566927) + 0.5;
return((long)rnd_x);
}

#else

int rnd_x;

/**************************************/
/* pseudo random number generator two */
/**************************************/
int
rnd()
{
rnd_x = (rnd_x * 11109) + 13849;
return((rnd_x & 0xfff) >> 1);
}

#endif

#endif

/****************************************************/
/* generates a seed for the random number generator */
/****************************************************/
int
get_seed ()
{
int	seed;
struct	tm	*timestruct;
long	clock;
clock = time(0);
timestruct = localtime(&clock);
seed = timestruct->tm_sec  +
       timestruct->tm_min  +
       timestruct->tm_hour +
       timestruct->tm_mday +
       timestruct->tm_mon  +
       timestruct->tm_year +
       timestruct->tm_yday;
return((int) ((seed + clock) % 32767));
}

/***********************************************/
/* generates a random number between 0 and 100 */
/***********************************************/
int
random()
{
#ifdef MY_RAND
return(rnd() % 101);
#else
return(rand() % 101);
#endif
}

/*******************************************/
/* initializes the random number generator */
/*******************************************/
init_random()
{
int seed;
register int i;
seed = get_seed();
#ifdef MY_RAND
#ifdef RND_ONE
    for (i=0; i<seed; i++)
         rnd();
#else
    rnd_x = seed;
#endif
#else
    srand((unsigned)seed);
#endif
}

/*********** end of program **********/
