/* move.c */
/* transportable    */

/**********************************************************************/
/*                                                                    */
/*           MM   MM  IIIIIII  L        L        EEEEEEE              */
/*           M M M M     I     L        L        E                    */
/*           M  M  M     I     L        L        EEEE                 */
/*           M     M     I     L        L        E                    */
/*           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              */
/*                                                                    */
/*      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          */
/*      B     B  O     O  R     R  N N   N  E        S                */
/*      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           */
/*      B     B  O     O  R    R   N   N N  E              S          */
/*      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           */
/*                                                                    */
/*                                                                    */
/* Creation: Edmond Dujardin                                          */
/*           (c) 1962 Parker Brothers, Inc.                           */
/*                                                                    */
/* Written by: Brett K. Carver                                        */
/*             Hewlett-Packard, 1983.                                 */
/*                                                                    */
/* Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             */
/*                                                                    */
/**********************************************************************/

#include "miles.h"

/**********************************************************************/
/*                                                                    */
/*              CONSTANTS AND VARIABLES                               */
/*                                                                    */
/**********************************************************************/

/**********************************/
/* external procedure definitions */
/**********************************/

extern move_string();
extern message ();

/*********************************/
/* external variable definitions */
/*********************************/

extern int hand[2][15];         /* current status of players */
extern int change[2][15];       /* parallel structure of booleans */
extern int discard;             /* card being discarded */
extern int extension;           /* boolean for extension */
extern long *card_names[40];    /* array of pointers to pointers to text */

extern char *T_no_card;
extern char *T_cant_play;
extern char *T_dont_need;
extern char *T_exact_700;
extern char *T_exact_1000;
extern char *T_only_two_200;

/**********************************************************************/
/*                                                                    */
/*              UTILITIES TO VERIFY A MOVE                            */
/*                                                                    */
/**********************************************************************/

/************************************/
/* prints can't play error messages */
/************************************/
cant_play(who,card,beep)
int who;
int card;
int beep;
{
if (who == you && beep) {
    move_string(card_names[card],T_cant_play + 17,20);
    message(T_cant_play,FALSE);
    }
}

/************************************/
/* prints don't need error messages */
/************************************/
dont_need(who,card,beep)
int who;
int card;
int beep;
{
if (who == you && beep) {
    move_string(card_names[card],T_dont_need + 17,20);
    message(T_dont_need,FALSE);
    }
}

/*************************************/
/* prints exact score error messages */
/*************************************/
exact_miles(who,score_limit,beep)
int who;
int score_limit;
int beep;
{
if (who == you && beep) {
    if (score_limit == 700)
         message(T_exact_700,FALSE);
    else
         message(T_exact_1000,FALSE);
    }
}

/**************************************************/
/* checks to see if the player can play that card */
/* returns TRUE if he can, FLASE if he can't      */
/**************************************************/
valid_move(who,card_number,play,beep)
int who;
int card_number;
int play;
int beep;
{
int other_guy;
int score_limit;
other_guy = who ? you : me; /* find out who the other hand belongs to */
score_limit = extension ? 1000 : 700; /* get maximum miles */
switch (hand[who][card_number]) {
    case 0: {
         if (who == you && beep)
              message(T_no_card,FALSE);
         return(FALSE);
         }
    case extra_tank: {
         return(TRUE);
         }
    case puncture_proof: {
         return(TRUE);
         }
    case driving_ace: {
         return(TRUE);
         }
    case right_of_way: {
         return(TRUE);
         }
    case gasoline: {
         if (play)
              if (hand[who][battle] == out_of_gas)
                   return(TRUE);
              else {
                   dont_need(who,gasoline,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case spare_tire: {
         if (play)
              if (hand[who][battle] == flat_tire)
                   return(TRUE);
              else {
                   dont_need(who,spare_tire,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case repairs: {
         if (play)
              if (hand[who][battle] == accident)
                   return(TRUE);
              else {
                   dont_need(who,repairs,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case end_of_limit: {
         if (play)
              if (hand[who][limit] == speed_limit)
                   return(TRUE);
              else {
                   dont_need(who,end_of_limit,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case roll: {
         if (play)
              if (hand[who][battle] == stop ||
                  hand[who][battle] == gasoline ||
                  hand[who][battle] == spare_tire ||
                  hand[who][battle] == repairs)
                   return(TRUE);
              else {
                   dont_need(who,roll,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case out_of_gas: {
         if (play)
              if (hand[other_guy][battle] == roll &&
                  ! (hand[other_guy][safety] & 0x1))
                   return(TRUE);
              else {
                   cant_play(who,out_of_gas,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case flat_tire: {
         if (play)
              if (hand[other_guy][battle] == roll &&
                  ! (hand[other_guy][safety] & 0x2))
                   return(TRUE);
              else {
                   cant_play(who,flat_tire,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case accident: {
         if (play)
              if (hand[other_guy][battle] == roll &&
                  ! (hand[other_guy][safety] & 0x4))
                   return(TRUE);
              else {
                   cant_play(who,accident,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case speed_limit: {
         if (play)
              if (hand[other_guy][limit] == end_of_limit &&
                  ! (hand[other_guy][safety] & 0x8))
                   return(TRUE);
              else {
                   cant_play(who,speed_limit,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case stop: {
         if (play)
              if (hand[other_guy][battle] == roll &&
                  ! (hand[other_guy][safety] & 0x8))
                   return(TRUE);
              else {
                   cant_play(who,stop,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case miles_200: {
         if (play)
              if (hand[who][miles] + 200 <= score_limit &&
                  hand[who][battle] == roll &&
                  hand[who][limit] == end_of_limit &&
                  hand[who][cnt_200] < 2)
                   return(TRUE);
              else {
                   if (hand[who][miles] + 200 > score_limit)
                        exact_miles(who,score_limit,beep);
                   else if (hand[who][cnt_200] == 2) {
                        if (who == you && beep)
                             message(T_only_two_200,FALSE);
                        }
                   else
                        cant_play(who,miles_200,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case miles_100: {
         if (play)
              if (hand[who][miles] + 100 <= score_limit &&
                  hand[who][battle] == roll &&
                  hand[who][limit] == end_of_limit)
                   return(TRUE);
              else {
                   if (hand[who][miles] + 100 > score_limit)
                        exact_miles(who,score_limit,beep);
                   else
                        cant_play(who,miles_100,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case miles_75: {
         if (play)
              if (hand[who][miles] + 75 <= score_limit &&
                  hand[who][battle] == roll &&
                  hand[who][limit] == end_of_limit)
                   return(TRUE);
              else {
                   if (hand[who][miles] + 75 > score_limit)
                        exact_miles(who,score_limit,beep);
                   else
                        cant_play(who,miles_75,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case miles_50: {
         if (play)
              if (hand[who][miles] + 50 <= score_limit &&
                  hand[who][battle] == roll)
                   return(TRUE);
              else {
                   if (hand[who][miles] + 50 > score_limit)
                        exact_miles(who,score_limit,beep);
                   else
                        cant_play(who,miles_50,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    case miles_25: {
         if (play)
              if (hand[who][miles] + 25 <= score_limit &&
                  hand[who][battle] == roll)
                   return(TRUE);
              else {
                   if (hand[who][miles] + 25 > score_limit)
                        exact_miles(who,score_limit,beep);
                   else
                        cant_play(who,miles_25,beep);
                   return(FALSE);
                   }
         else
              return(TRUE);
         }
    }
return(FALSE);	/* never gets here */
}

/**********************************************************************/
/*                                                                    */
/*              UTILITIES TO MAKE MOVES                               */
/*                                                                    */
/**********************************************************************/

/****************************/
/* makes the requested play */
/****************************/
play_card(who,card_number,play)
int who;
int card_number;
int play;
{
int other_guy;
int play_again;
other_guy = who ? you : me; /* find out who the other hand belongs to */
play_again = FALSE;
if (play)
    switch (hand[who][card_number]) {
         case extra_tank: {
              hand[who][safety] |= 0x1;
              change[who][safety] = TRUE;
              if (hand[who][battle] == out_of_gas) {
                   hand[who][battle] = roll;
                   change[who][battle] = TRUE;
                   if (card_number != 6 && hand[who][coups] & 0x10)
                        hand[who][coups] |= 0x1;
                   }
              play_again = TRUE;
              break;
              }
         case puncture_proof: {
              hand[who][safety] |= 0x2;
              change[who][safety] = TRUE;
              if (hand[who][battle] == flat_tire) {
                   hand[who][battle] = roll;
                   change[who][battle] = TRUE;
                   if (card_number != 6 && hand[who][coups] & 0x10)
                        hand[who][coups] |= 0x2;
                   }
              play_again = TRUE;
              break;
              }
         case driving_ace: {
              hand[who][safety] |= 0x4;
              change[who][safety] = TRUE;
              if (hand[who][battle] == accident) {
                   hand[who][battle] = roll;
                   change[who][battle] = TRUE;
                   if (card_number != 6 && hand[who][coups] & 0x10)
                        hand[who][coups] |= 0x4;
                   }
              play_again = TRUE;
              break;
              }
         case right_of_way: {
              hand[who][safety] |= 0x8;
              change[who][safety] = TRUE;
              if (hand[who][battle] == stop) {
                   hand[who][battle] = roll;
                   change[who][battle] = TRUE;
                   if (card_number != 6 && hand[who][coups] & 0x10)
                        hand[who][coups] |= 0x8;
                   }
              if (hand[who][limit] == speed_limit) {
                   hand[who][limit] = end_of_limit;
                   change[who][limit] = TRUE;
                   if (card_number != 6 && hand[who][coups] & 0x20)
                        hand[who][coups] |= 0x8;
                   }
              if (hand[who][battle] == gasoline ||
                  hand[who][battle] == spare_tire ||
                  hand[who][battle] == repairs) {
                   hand[who][battle] = roll;
                   change[who][battle] = TRUE;
                   }
              play_again = TRUE;
              break;
              }
         case gasoline: {
              hand[who][battle] = gasoline;
              change[who][battle] = TRUE;
              if (hand[who][safety] & 0x8)
                   hand[who][battle] = roll;
              break;
              }
         case spare_tire: {
              hand[who][battle] = spare_tire;
              change[who][battle] = TRUE;
              if (hand[who][safety] & 0x8)
                   hand[who][battle] = roll;
              break;
              }
         case repairs: {
              hand[who][battle] = repairs;
              change[who][battle] = TRUE;
              if (hand[who][safety] & 0x8)
                   hand[who][battle] = roll;
              break;
              }
         case end_of_limit: {
              hand[who][limit] = end_of_limit;
              change[who][limit] = TRUE;
              break;
              }
         case roll: {
              hand[who][battle] = roll;
              change[who][battle] = TRUE;
              break;
              }
         case out_of_gas: {
              hand[other_guy][battle] = out_of_gas;
              change[other_guy][battle] = TRUE;
              hand[other_guy][coups] |= 0x10;       /* a coup is possible */
              break;
              }
         case flat_tire: {
              hand[other_guy][battle] = flat_tire;
              change[other_guy][battle] = TRUE;
              hand[other_guy][coups] |= 0x10;       /* a coup is possible */
              break;
              }
         case accident: {
              hand[other_guy][battle] = accident;
              change[other_guy][battle] = TRUE;
              hand[other_guy][coups] |= 0x10;       /* a coup is possible */
              break;
              }
         case speed_limit: {
              hand[other_guy][limit] = speed_limit;
              change[other_guy][limit] = TRUE;
              hand[other_guy][coups] |= 0x20;       /* a coup is possible */
              break;
              }
         case stop: {
              hand[other_guy][battle] = stop;
              change[other_guy][battle] = TRUE;
              hand[other_guy][coups] |= 0x10;       /* a coup is possible */
              break;
              }
         case miles_200: {
              hand[who][miles] += 200;
              change[who][miles] = TRUE;
              hand[who][cnt_200]++;
              change[who][cnt_200] = TRUE;
              break;
              }
         case miles_100: {
              hand[who][miles] += 100;
              change[who][miles] = TRUE;
              break;
              }
         case miles_75: {
              hand[who][miles] += 75;
              change[who][miles] = TRUE;
              break;
              }
         case miles_50: {
              hand[who][miles] += 50;
              change[who][miles] = TRUE;
              break;
              }
         case miles_25: {
              hand[who][miles] += 25;
              change[who][miles] = TRUE;
              break;
              }
         }
else
    discard = hand[who][card_number];
hand[who][card_number] = hand[who][6];
change[who][card_number] = TRUE;
hand[who][6] = 0;
change[who][6] = TRUE;
hand[who][coups] &= 0x0F;        /* remove possible coup */
return(play_again);
}

/*********** end of program **********/
