/* io.c */
/* machine dependent */

/**********************************************************************/
/*                                                                    */
/*           MM   MM  IIIIIII  L        L        EEEEEEE              */
/*           M M M M     I     L        L        E                    */
/*           M  M  M     I     L        L        EEEE                 */
/*           M     M     I     L        L        E                    */
/*           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              */
/*                                                                    */
/*      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          */
/*      B     B  O     O  R     R  N N   N  E        S                */
/*      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           */
/*      B     B  O     O  R    R   N   N N  E              S          */
/*      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           */
/*                                                                    */
/*                                                                    */
/* Creation: Edmond Dujardin                                          */
/*           (c) 1962 Parker Brothers, Inc.                           */
/*                                                                    */
/* Written by: Brett K. Carver                                        */
/*             Hewlett-Packard, 1983.                                 */
/*                                                                    */
/* Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/* WARNING                                                            */
/*                                                                    */
/* The following file may be offensive to UNIX purists. The original  */
/* implementation was created on a non-UNIX machine that did not have */
/* any of the standard I/O facilities. Many of the shortcomings of    */
/* its previous life live on in this ported version.                  */
/*                                                                    */
/* You have been warned...                                            */
/*                                                                    */
/**********************************************************************/

#ifndef COHERENT
#include <curses.h>
#else
#include <ncurses.h>
#endif
#include <signal.h>
#include "miles.h"

/**********************************************************************/
/*                                                                    */
/*              CONSTANTS AND VARIABLES                               */
/*                                                                    */
/**********************************************************************/

/**********************************/
/* external procedure definitions */
/**********************************/

extern display_pick();
extern random();
extern refresh_screen();

/*********************************/
/* external variable definitions */
/*********************************/

extern int play;                /* play=TRUE, discard=FALSE, drawn=-1 */
extern int extension;           /* boolean for extension */
extern int debug;               /* flag for debug output */
extern char * temp_screen;

extern char *T_extension_yes;
extern char *T_extension_no;
extern char *T_another_yes;
extern char *T_another_no;
extern char *T_match_yes;
extern char *T_match_no;
extern char *T_anychar;
extern char *T_version;
extern char *B_intro[];

/**********************************************************************/
/*                                                                    */
/*              DISPLAY AND FORMATTING UTILITIES                      */
/*                                                                    */
/**********************************************************************/

/*************************/
/* cleanup the screen io */
/*************************/
cleanup_io()
{
clear();
refresh();
endwin();
exit(0);
}

/****************************/
/* initialize the screen io */
/****************************/
initialize_io()
{
signal(SIGINT,cleanup_io);
signal(SIGQUIT,cleanup_io);
signal(SIGTERM,cleanup_io);
initscr();
noecho();
cbreak();
}

/************************/
/* write out the screen */
/************************/
write_screen()
{
refresh();
}

/***************************/
/* write out screen banner */
/***************************/
display_banner()
{
char **s;
int i;
clear();
s = B_intro;
move(0,0);
i = 0;
while (*s) {
    printw("%s\n",*s++);
    i++;
    if (i>22) {
         move(23,0);
         printw("%s",T_anychar);
         refresh();
         if (getch() == '\n') {
              clear();
              return;
              }
         clear();
         move(0,0);
         i = 0;
         }
    }
move(23,0);
printw("%s",T_anychar);
refresh();
getch();
clear();
}

/***************************************/
/* blank screen from location thru end */
/***************************************/
clear_screen(row,column)
int row;
int column;
{
move(row,column);
clrtobot();
}

/************************************/
/* write out a status/error message */
/************************************/
message (string,status)
char * string;
int status;
{
move(23,0);
clrtoeol();
move(23,0);
if (status) {
         addstr(string);
         }
    else {
         addstr(string);
         beep();
         }
refresh();
}

/*******************************************************/
/* interface to formatter                              */
/* formats value to loaction pointed to by destination */
/*******************************************************/
format (value,row,column)
int value ;
int row;
int column;
{
move(row,column);
printw("%d  ",value);
}

/*****************************************/
/* places the string pointed to in a     */
/* length character field, blank filling */
/*****************************************/
place_string(string,row,column,length)
char *string;
int row;
int column;
int length;
{
int i;
char *temp;
temp = temp_screen;
for (i=0; i<length; i++)
    *temp++ = ' ';
*temp = '\0';
move(row,column);
addstr(temp_screen);
move(row,column);
addstr(string);
}

/*****************************************/
/* moves the string pointed to in a      */
/* length character field, blank filling */
/*****************************************/
move_string(string,destination,length)
char *string;
char *destination;
int length;
{
int i;
i = 0;
while ((*string != '\0') && (i < length)) {       /* copy string */
    *destination++ = *string++;
    i++;
    }
for (i; i<length; i++)
    *destination++ = ' ';
}

/**********************************************************************/
/*                                                                    */
/*              INPUT UTILITIES                                       */
/*                                                                    */
/**********************************************************************/

/*************************/
/* waits for you to move */
/*************************/
wait_for_move()
{
while (TRUE) {
    random();                      /* help randomize */
    switch (getch()) {
         case '5': 
         case 'd': 
         case 'k': {             /* toggle */
              play = !play;
              display_pick(0);
              break;
              }
         case '6': 
         case 's': 
         case 'l': {             /* down */
              display_pick(1);
              break;
              }
         case '0': 
         case ',': 
         case 'a': 
         case ';': 
         case ' ': {             /* doit */
              display_pick(-2);
              return;
              }
         case '4': 
         case 'f': 
         case 'j': {             /* up */
              display_pick(-1);
              break;
              }
         case '?': {
              display_banner();
              clear();
              refresh_screen(FALSE);
              display_pick(0);
              break;
              }
         case 'Q': {             /* quit */
              cleanup_io();
              break;
              }
         case '!': {             /* shell escape */
              shell();
              }      /* keep going */
         case '': {
              clear();
              refresh_screen(FALSE);
              display_pick(0);
              break;
              }
         case 'v':
         case 'V': {
              message(T_version,TRUE);
              break;
              }
         case 'D': {                            /* <=========== debug */
              debug = !debug;                   /*                    */
              break;                            /*                    */
              }                                 /* <=========== debug */
         }
    }
}

/*****************************/
/* asks for extension yes/no */
/*****************************/
extension_question()
{
extension = TRUE;
while (TRUE) {
    if (extension)
         message(T_extension_yes,TRUE);
    else
         message(T_extension_no,TRUE);
    random();                      /* help randomize */
    switch (getch()) {
         case '5': 
         case 'd': 
         case 'k': {             /* toggle */
              extension = !extension; /* extension */
              break;
              }
         case '0': 
         case ',': 
         case 'a': 
         case ';': 
         case ' ': {             /* doit */
              return(extension);
              break;
              }
         case 'Q': {             /* quit */
              cleanup_io();
              break;
              }
         case '!': {             /* shell escape */
              shell();
              }      /* keep going */
         case '': {
              clear();
              refresh_screen(FALSE);
              break;
              }
         }
    }
}

/********************************/
/* asks for another game yes/no */
/********************************/
another_question()
{
int another;
another = TRUE;
while (TRUE) {
    if (another)
         message(T_another_yes,TRUE);
    else
         message(T_another_no,TRUE);
    random();                      /* help randomize */
    switch (getch()) {
         case '5': 
         case 'd': 
         case 'k': {             /* toggle */
              another = !another; /* another */
              break;
              }
         case '0': 
         case ',': 
         case 'a': 
         case ';': 
         case ' ': {             /* doit */
              return(another);
              break;
              }
         case 'Q': {             /* quit */
              cleanup_io();
              break;
              }
         case '!': {             /* shell escape */
              shell();
              }      /* keep going */
         case '': {
              clear();
              refresh_screen(TRUE);
              break;
              }
         }
    }
}

/*********************************/
/* asks for another match yes/no */
/*********************************/
another_match()
{
int another;
another = TRUE;
while (TRUE) {
    if (another)
         message(T_match_yes,TRUE);
    else
         message(T_match_no,TRUE);
    random();                      /* help randomize */
    switch (getch()) {
         case '5': 
         case 'd': 
         case 'k': {             /* toggle */
              another = !another; /* another */
              break;
              }
         case '0': 
         case ',': 
         case 'a': 
         case ';': 
         case ' ': {             /* doit */
              return(another);
              break;
              }
         case 'Q': {             /* quit */
              cleanup_io();
              break;
              }
         case '!': {             /* shell escape */
              shell();
              }      /* keep going */
         case '': {
              clear();
              refresh_screen(TRUE);
              break;
              }
         }
    }
}

/**************************/
/* perform a shell escape */
/**************************/
shell()
{
extern char * getenv();	/* to stop the warning */
int pid;
char *sh;
int ret_status;
sh = getenv("SHELL");
clear();
move(0,0);
refresh();
endwin();
fflush(stdout);
while((pid = fork()) < 0)
     sleep(1);
if (pid == 0) {
    setuid(getuid());
    setgid(getgid());
    execl(sh == NULL ? "/bin/sh" : sh, "shell", "-i", 0);
    perror("No shelly");
    exit(-1);
    }
else {
    signal(SIGINT, SIG_IGN);
    signal(SIGQUIT, SIG_IGN);
    while (wait(&ret_status) != pid)
         continue;
    signal(SIGINT, cleanup_io);
    signal(SIGQUIT, cleanup_io);
    initscr();
    noecho();
    cbreak();
    }
}
/*********** end of program **********/
