/* data.c */
/* transportable */

/**********************************************************************/
/*                                                                    */
/*           MM   MM  IIIIIII  L        L        EEEEEEE              */
/*           M M M M     I     L        L        E                    */
/*           M  M  M     I     L        L        EEEE                 */
/*           M     M     I     L        L        E                    */
/*           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              */
/*                                                                    */
/*      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          */
/*      B     B  O     O  R     R  N N   N  E        S                */
/*      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           */
/*      B     B  O     O  R    R   N   N N  E              S          */
/*      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           */
/*                                                                    */
/*                                                                    */
/* Creation: Edmond Dujardin                                          */
/*           (c) 1962 Parker Brothers, Inc.                           */
/*                                                                    */
/* Written by: Brett K. Carver                                        */
/*             Hewlett-Packard, 1983.                                 */
/*                                                                    */
/* Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/*                                                                    */
/*              CONSTANTS AND VARIABLES                               */
/*                                                                    */
/**********************************************************************/

/********************/
/* global variables */
/********************/

char temp_screen_buffer[32];
char * temp_screen = &temp_screen_buffer[0];
int cards_played[20];           /* set of cards already played */
int deck[20];                   /* shufled deck of cards */
int hand[2][15];                /* current status of players */
int change[2][15];              /* parallel structure of booleans */
int discard;                    /* card being discarded */
int play;                       /* play=TRUE, discard=FALSE, drawn=-1 */
int card_number;                /* card to play */
int extension;                  /* boolean for extension */
int delayed_action;             /* boolean for delayed action game */
int whose_turn;                 /* you, me, or -1 if game done */
int debug;                      /* flag for debug output */

/*****************************/
/* card names and other text */
/*****************************/

char *card_names[] =            /* array of pointers to pointers to text */
                {
                " ",
                "extra tank",           /* safeties */
                "puncture-proof",
                "driving ace",
                "right-of-way",
                "gasoline",             /* remedies */
                "spare tire",
                "repairs",
                "end of limit",
                "roll",
                "out of gas",           /* haxards */
                "flat tire",
                "accident",
                "speed limit",
                "stop",
                "200",                  /* distance */
                "100",
                "75",
                "50",
                "25",
                "  YOUR STATUS ",       /* screen text */
                "  MY STATUS ",
                " Miles",
                " Hand",
                " Game",
                " Last Discard",
                " Cards Left",
                "drawn -->",
                "play --->",
                "discard >",
                "safe trip",            /* game messages */
                "one 200",
                "two 200's",
                "coup fourre'",
                " scoring",            /* scoring */
                "miles, 1/",
                "safety, 100/",
                "all 4 safeties, 300",
                "coup fourre, 300/",
                "trip complete, 400",
                "delayed action, 300",
                "safe trip, 300",
                "extension, 200",
                "shut-out, 500"
                };

/****************/
/* message text */
/****************/

char * T_shuffling_cards = "shuffling cards ";
char * T_dealing_cards   = "dealing cards ";
char * T_make_play       = "play/discard a card ";
char * T_no_card         = "there's no card there ";
char * T_cant_play       = "you can't play a                         ";
char * T_dont_need       = "you don't need a                         ";
char * T_exact_700       = "you need exactly 700 miles ";
char * T_exact_1000      = "you need exactly 1000 miles ";
char * T_only_two_200    = "you may only play two 200's ";
char * T_extension_yes   = "go for extension? YES ";
char * T_extension_no    = "go for extension? NO  ";
char * T_another_yes     = "another game? YES ";
char * T_another_no      = "another game? NO  ";
char * T_match_yes       = "another match? YES ";
char * T_match_no        = "another match? NO  ";
char * T_you_won         = "congratulations: you won ";
char * T_me_won          = "sorry about that, I won ";
char * T_anychar         = "any character for more, return to start game ";
char * T_endgame         = "No more playable cards, hit any character for score ";
char * T_version         = "Mille Bornes, (c) Brett Carver, 1986. Version: 3.0. ";

/***************/
/* screen text */
/***************/

char * B_intro[] = {
/* screen 1 */
"     **********************************************************************",
"     *                                                                    *",
"     *           MM   MM  IIIIIII  L        L        EEEEEEE              *",
"     *           M M M M     I     L        L        E                    *",
"     *           M  M  M     I     L        L        EEEE                 *",
"     *           M     M     I     L        L        E                    *",
"     *           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              *",
"     *                                                                    *",
"     *      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          *",
"     *      B     B  O     O  R     R  N N   N  E        S                *",
"     *      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           *",
"     *      B     B  O     O  R    R   N   N N  E              S          *",
"     *      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           *",
"     *                                                                    *",
"     *                                                                    *",
"     * Creation: Edmond Dujardin, (c) 1962 Parker Brothers, Inc.          *",
"     *                                                                    *",
"     * Written by: Brett K. Carver, Hewlett-Packard, 1983.                *",
"     *                                                                    *",
"     * Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             *",
"     *                                                                    *",
"     **********************************************************************",
" ",
/* screen 2 */
"A BRIEF summary of the rules for Mille Bornes (pronounced Meel-Born) follows:",
" ",
"The first player to reach 10,000 points wins the match.  The first player to",
"reach either 700 or 1,000 Miles exactly wins a game.  (There is an option at",
"700 Miles to continue the game onto 1,000 Miles.)",
" ",
"The cards:",
"     Hazards           Remedies           Safeties",
"        2 Out of Gas      6 Gasoline         1 Extra Tank",
"        2 Flat Tire       6 Spare Tire       1 Puncture Proof",
"        2 Accident        6 Repairs          1 Driving Ace",
"        3 Speed Limit     6 End of Limit   \\",
"        4 Stop           14 Roll           / 1 Right of way",
" ",
"You need a green light (Roll) to play distance cards (Miles).  If you have a",
"Speed Limit then you can only go 25 or 50 Miles (per turn) until you get an",
"End Of Limit.  If you have a red light (Stop) then you must get a green light.",
"If you have an Accident, you must get Repairs and then a green light.  If you",
"run Out Of Gas, you must get Gasoline and a green light.  If you have a Flat",
"Tire, you must get a Spare Tire and a green light.  Makes sense, doesn't it.",
" ",
"A Speed Limit card may be played on your 'opponent' even when 'he' has a hazard",
"or a Stop.  No more than two 200 Mile cards may be played.",
/* screen 3 */
"A safety card prevents the corresponding hazard to be played on you.  For",
"example, once you have played the Driving Ace safety, you cannot get into an",
"Accident.  If you still have the Driving Ace card in your hand and get into an",
"Accident, you can play it to get a Coup Fourre' (pronounced Coo-Foo-Ray) and",
"remove the Accident.  Whenever a safety card is played, you get another turn.",
"The Right Of Way safety prevents both stops and speed limits.  Note: The safety",
"card must be in your hand when your 'opponent' plays the hazard and therefore",
"the draw card is not eligible for a Coup Fourre'.",
" ",
"Do not keep unnecessary cards.  If you have the Driving Ace card, do not keep",
"Repair cards.  If both Out Of Gas cards have been played, do not keep Gasoline",
"cards.",
" ",
"Scoring:",
"     Milestones played                Face Value",
"     Each safety card played                 100",
"     All 4 safeties played                   300",
"     Each coup fourre'                       300",
"     Trip complete (700 or 1000)             400",
"     Delayed action (no draw cards left)     300",
"     Safe trip (no 200's)                    300",
"     Extension (making it to 1000)           200",
"     Shut-out (opponent has 0 miles)         500",
/* screen 4 */
"The game input is designed so that the whole game may be played without moving",
"your hand around the keyboard. Cards are played by: moving a pointer to the",
"card of choice, toggling between play/discard, and performing the action.",
"There are three places your hand may be placed. In all cases, the same fingers",
"will perform the same actions.",
" ",
"action:  doit         up     toggle  down",
" ",
"finger:  thumb/       index  middle  ring",
"         little",
" ",
"key:     ' ' or ';'   'j'    'k'     'l'   right hand on the home position",
"         ' ' or 'a'   'f'    'd'     's'   left hand on the home position",
"         '0' or ','   '4'    '5'     '6'   right hand on the numeric key pad",
" ",
"In addition:",
"    ! - shell escape,  ? - help,  ^L - redraw screen,  Q - quit,  V - version",
" ",
"The game is fairly easy to pick up by just diving in and playing it. Watching",
"how the computer plays will help also.",
" ",
"Good luck!",
0 };

/*********** end of program **********/
