NAME
     make - maintain, update, and reconstruct groups of programs

SYNOPSIS
     make [-f file] [-dDeiknqrsStWb-] [target...] [macro=value ...]

DESCRIPTION
     MAKE takes a file of dependencies (a 'makefile') and decides what
     commands have to be executed to bring the files up to date.  These
     commands are either executed directly from MAKE or written to the
     standard output without executing them.

     If no makefile is specified with a -f option, MAKE reads a file
     named `makefile', if it exists.

     If no target is specified on the command line, MAKE uses the first
     target defined in the first makefile.

OPTIONS
     -f makefile
         Use the description file `makefile'.  A - as the makefile
         argument denotes the standard input.

     -d  Display the reasons why MAKE chooses to rebuild a target.  All
         dependencies which are newer are displayed

     -dd Display the dependency checks in more detail.  Dependencies
         which are older are displayed, as well as newer.

     -D  Display the text of the makefiles as read in.

     -DD Display the text of the makefiles and `default.mk'.

     -e  Let environment variables override macro definitions from
         makefiles.  Normally, makefile macros override environment
         variables.  Command line macro definitions always override both
         environment variables and makefile macros definitions.

     -i  Ignore error codes returned by commands.  This is equivalent to
         the special target .IGNORE:.

     -k  When a nonzero error status is returned by a command, abandon
         work on the current target, but continue with other branches
         that do not depend on this target.

     -n  No execution mode.  Print commands, but do not execute them.
         Even lines beginning with an @ are printed.  However, if a
         command line is an invocation of MAKE, that line is always
         executed.

     -q  Question mode.  MAKE returns a zero or non-zero status code,
         depending on whether or not the target file is up to date.

     -r  Do not read in the default file `default.mk'.

     -s  Silent mode.  Do not print command lines before executing them.
         This is equivalent to the special target .SILENT:.

     -S  Undo the effect of the -k option.  Stop processing when a
         non-zero exit status is returned by a command.

     -t  Touch the target files, bringing them up to date, rather than
         performing the rules to reconstruct them.

     -W target
         Perform the make as if this target has a modification time of
         "right now".  This is the "What If?" option.

     -b  This option is accepted and ignored.  It allows compatibility
         with older makefiles (and scripts).

     --  This option is accepted and ignored.  It allows compatibility
         with SCO Xenix which requires -$(MAKEFLAGS).  This version of
         make includes a '-' within $(MAKEFLAGS).

     macro=value
         Macro definition.  This definition remains fixed for the MAKE
         invocation.  It overrides any regular definitions for the
         specified macro within the makefiles and from the environment.
         It is inherited by subordinate MAKE's but act as an environment
         variable for these.  That is, depending on the -e setting, it
         may be overridden by a makefile definition.

USAGE
  Makefiles
     The first makefile read is `default.mk', which can be located any-
     where along the PATH.  It typically contains predefined macros and
     implicit rules.  For non-DOS systems (e.g.  Unix), it is searched
     for in the current directory, then in the users home directory, and
     finally along the PATH.

     The default name of the makefile is `makefile' in the current
     directory.  If this file is not found on a non-DOS system, the file
     `Makefile' is then used as the default.  Alternate makefiles can be
     specified using one or more '-f' options on the command line.
     Multiple '-f's act as the concatenation of all the makefiles in a
     left-to-right order.

     The makefile(s) may contain a mixture of comment lines, macro
     definitions, include lines, and target lines.  Lines may be
     continued across input lines by escaping the NEWLINE with a
     backslash (\).

     Anything after a "#" is considered to be a comment, and is stripped
     from the line, including spaces immediately before the "#.  If the
     "#" is inside a quoted string, it is not treated as a comment.
     Completely blank lines are ignored.

     An include line is used to include the text of another makefile.
     It consists of the word "include" left justified, followed by
     spaces, and followed by the name of the file that is to be included
     at this line.  Macros in the name of the included file are expanded
     before the file is included.  Include files may be nested.

  Macros
     Macros have the form `WORD = text and more text'.  The WORD need
     not be uppercase, but this is an accepted standard.  Later lines
     which contain $(WORD) or ${WORD} will have this replaced by `text
     and more text'.  If the macro name is a single character, the
     parentheses are optional.  Note that the expansion is done
     recursively, so the body of a macro may contain other macro
     invocations.

	e.g.	FLINTSTONES = wilma and fred
		RUBBLES = barney and betty
		BEDROCK = $(FLINTSTONES) and $(RUBBLES)

     `$(BEDROCK)' becomes `wilma and fred and barney and betty'

     Also note that whitespace around the equal sign is not relevant
     when defining a macro.  The following four macro definitions are
     all equivalent:

		MACRO = body
		MACRO=  body
		MACRO  =body
		MACRO=body

     Macros may be added to by using the `+=' notation.  Thus

		FLINTSTONES += and pebbles and dino

     would be (given the examples above) the same as

		FLINTSTONES = wilma and fred and pebbles and dino

  Special Macros
     MAKE
         This normally has the value "make".  Any line which invokes
         MAKE temporarily overrides the -n option, just for the duration
         of the one line.  This allows nested invocations of MAKE to be
         tested with the -n option.

     MAKEFLAGS
         This macro has the set of options provided to MAKE as its
         value.  If this is set as an environment variable, the set of
         options is processed before any command line options.  This
         macro may be explicitly passed to nested MAKEs, but it is also
         available to these invocations as an environment variable.  The
         -f and -d flags are not recorded in this macro.

     SUFFIXES
         This contains the default list of suffixes supplied to the
         special target .SUFFIXES:.  It is not sufficient to simply
         change this macro in order to change the .SUFFIXES: list.  That
         target must be specified in your makefile.

     SHELLCMD
         This contains the default list of commands which are local to
         the SHELL.  If a rule is an invocation of one of these
         commands, a SHELL is automatically spawned to handle it.

     $   This macro translates to a dollar sign.  Thus you can use "$$"
         in the makefile to represent a single "$".

     There are several dynamically maintained macros that are useful as
     abbreviations within rules.  It is best not to define them
     explicitly.

     $*  The basename of the current target.

     $<  The name of the current dependency file.

     $@  The name of the current target.

     $?  The names of dependents which are younger than the target.

     The $< and $* macros are normally used for implicit rules.  They
     may be unreliable when used within explicit target command lines.
     These may be suffixed with D and F, to specify the Directory and
     Filename components (e.g. ${*D}, ${@F}).  If there is no directory
     in the name, "." is supplied.

  Targets
     A target entry in the makefile has the following format:

	target ... : [dependency ...] [; rule]
		[rule]
		...

     Any line which does not have leading whitespace (other than macro
     definitions) is a `target' line.  Target lines consist of one or
     more filenames (or macros which expand into same) called targets,
     followed by a colon (:).  The ':' is followed by a list of
     dependent files.  The dependency list may be terminated with a
     semicolon (;) which may be followed by a rule or shell command.

     Special allowance is made on MSDOS for the colons which are needed
     to specify files on other drives, so for example, the following
     will work as intended:

		c:foo.bar : a:fee.ber

     If a target is named in more than one target line, the dependencies
     and rules are added to form the target's complete dependency list
     and rule list.

     The dependents are ones from which a target is constructed.  They
     in turn may be targets of other dependents.  In general, for a
     particular target file, each of its dependent files is `made', to
     make sure that each is up to date with respect to it's dependents.

     The modification time of the target is compared to the modification
     times of each dependent file.  If the target is older, one or more
     of the dependents have changed, so the target must be constructed.
     Of course, this checking is done recursively, so that all
     dependents of dependents of dependents of ...  are up to date.

     To reconstruct a target, MAKE expands macros, strips off initial
     whitespace, and either executes the rules directly, or passes each
     to a shell or COMMAND.COM for execution.

     For target lines, macros are expanded on input.  All other lines
     have macro expansion delayed until absolutely required.

  Special Targets
     .DEFAULT:
         The rule for this target is used to process a target when there
         is no other entry for it, and no implicit rule for building it.
         MAKE ignores all dependencies for this target.

     .DONE:
         This target and its dependencies are processed after all other
         targets are built.

     .IGNORE:
         Non-zero error codes returned from commands are ignored.
         Encountering this in a makefile is the same as specifying -i on
         the command line.

     .INIT:
         This target and its dependencies are processed before any other
         targets are processed.

     .SILENT:
         Commands are not echoed before executing them.  Encountering
         this in a makefile is the same as specifying -s on the command
         line.

     .SUFFIXES:
         The suffixes list for selecting implicit rules.  Specifying
         this target with dependents adds these to the end of the
         suffixes list.  Specifying it with no dependents clears the
         list.  In order to add your own dependents to the head of the
         list, you could enter:

		.SUFFIXES:
		.SUFFIXES:	.abc $(SUFFIXES)

  Rules
     A line in a makefile that starts with a TAB or SPACE is a shell
     line or rule.  This line is associated with the most recently
     preceding dependency line.  A sequence of these may be associated
     with a single dependency line.  When a target is out of date with
     respect to a dependent, the sequence of commands is executed.
     Shell lines may have any combination of the following characters to
     the left of the command:

     @   will not echo the command line, except if -n is used.

     -   MAKE will ignore the exit code of the command, i.e.  the
         ERRORLEVEL of MSDOS.  Without this, MAKE terminates when a
         nonzero exit code is returned.

     +   MAKE will use a shell or COMMAND.COM to execute the command.

     If the '+' is not attached to a shell line, but the command is a
     DOS command or if redirection is used (<, |, >), the shell line is
     passed to COMMAND.COM anyway.  For Unix, redirection, backquote (`)
     parentheses and variables ($vname) force the use of a shell.

     For DOS, inline stdin (<<) operator is emulated with a temporary
     file.  That is, subsequent commands are written to a temporary
     file, and the name of the temporary file is placed in the command
     line.  For example, if you want to link a number of objects
     together, you can have a rule such as

         link $(OBJS),$(NAME),$(LDFLAGS),$(LIBS)

     If the resulting command line (after expansion) is greater than
     128, you can specify in the following manner.

	link @<<END_OF_LINK
		$(OBJS)
		$(NAME)
		$(LDFLAGS)
		$(LIBS)
	END_OF_LINK

     The four lines between the tags (END_OF_LINK) are written to a
     temporary file (e.g.  "\mk2"), and the command line is rewritten as
     "link @\mk2".

     The rules for redirection and tags are as follows:

        1)  If the redirector (<<) is immediately followed by some text,
            the text is used as the tag.  E.g.  "<<END_OF_LINK".

        2)  If the redirector is not immediately followed by some text,
            the next token is used as the tag.  E.g.  "<< END_OF_LINK".

        3)  If the redirector is the last token on a line, there is no
            tag.

        4)  Lines immediately following the command are written to a
            temporary file, until a line beginning with the tag is
            encountered or until the end of the current set of rules.

      The following are all equivalent.

	link @<<		link @<<END_OF_LINK	link @<<END_OF_LINK
		$(OBJS)			$(OBJS)			$(OBJS)
		$(PROG)			$(PROG)			$(PROG)
		$(LDFLAGS)		$(LDFLAGS)		$(LDFLAGS)
		$(LIBS)			$(LIBS)			$(LIBS)
				END_OF_LINK

  Implicit Rules
     Implicit rules are intimately tied to the .SUFFIXES: special
     target.  Each entry in the .SUFFIXES defines an extension to a
     filename which may be used to build another file.  The implicit
     rules then define how to actually build one file from another.
     These files are related, in that they must share a common basename,
     but have different extensions.

     If a file that is being made does not have an explicit target line,
     an implicit rule is looked for.  Each entry in the .SUFFIXES: list
     is combined with the extension of the target, to get the name of an
     implicit target.  If this target exists, it gives the rules used to
     transform a file with the dependent extension to the target file.
     Any dependents of the implicit target are ignored.

     In the following example, the .SUFFIXES: list is .c .y .l, and the
     target file is fred.o which does not have a target line.  An
     implicit rule target `.c.o' is constructed and searched for.  If it
     does not exist, the next suffix is tried.  If the implicit rule
     target does exist, MAKE looks for a file `fred.c'.  If this file
     does not exist, the next extension is tried.  If `fred.c' does
     exist, then the associated rules are executed to create fred.o from
     fred.c, presumably invoking the C compiler.

     If the next extension must be tried, MAKE reiterates the above with
     target `.y.o' and a file named `fred.y', and potentially with
     `.l.o' and `fred.l'.

     If a file that is being made has an explicit target, but no rules,
     a similar search is made for implicit rules.  Each entry in the
     .SUFFIXES: list is combined with the extension of the target, to
     get the name of an implicit target.  If such a target exists, then
     the list of dependents is searched for a file with the correct
     extension, and the implicit rules are invoked to create the target.

EXAMPLES
     This makefile says that pgm.exe depends on two files a.obj and
     b.obj, and that they in turn depend on their corresponding source
     files (a.c and b.c) along with the common file incl.h.

	pgm.exe: a.obj b.obj
		$(CC) a.obj b.obj -o $@

	a.obj:	incl.h a.c
		$(CC) -c a.c

	b.obj:	incl.h b.c
		$(CC) -c b.c

     The following makefile uses implicit rules to express the same
     dependencies.

	pgm.exe: a.obj b.obj
		$(CC) a.obj b.obj -o $@

	a.obj b.obj: incl.h

     This final makefile uses implicit rules to create targets with
     dependencies in a different directory.  Note: this cannot be done
     with standard Unix make.

	pgm.exe: a.obj b.obj
		$(CC) a.obj b.obj -o $@

	a.obj:	incl.h ../a.c

	b.obj:	incl.h ../b.c

FILES
     makefile            Current version(s) of make description file.
     Makefile            Alternative to makefile, for Unix.
     default.mk          Default file for user-defined targets, macros,
                         and implicit rules.

DIAGNOSTICS
     MAKE returns an exit status of 1 when it halts as a result of an
     error.  Otherwise it returns an exit status of 0.

     Badly formed macro
         A macro definition has been encountered which has incorrect
         syntax.  Most likely, the name is missing.

     cannot open file
         The makefile indicated in an include directive was not found or
         was not accessible.

     Don't know how to make target
         There is no makefile entry for target, none of MAKE's implicit
         rules apply, and there is no .DEFAULT: rule.

     Improper Macro.
         An error has occurred during macro expansion.  The most likely
         error is a missing closing bracket.

     Macro too long (limit 100 chars):
         A macro name is too long for the internal buffer.  Try shortening
	 it to 100 characters or less.

     rules must be after target
         A makefile syntax error, where a line beginning with a SPACE or
         TAB has been encountered before a target line.

     too many options
         MAKE has run out of allocated space while processing command
         line options or a target list.

     Too many rules defined for target
	 A target occurs multiple times, and each time has rules.  A
	 target may only have one set of rules.

     Unexpected end of line seen
         A target line without a colon has been encountered.

AUTHOR
     Greg Yachuk	  Informix Software Inc., Menlo Park, CA 92025
     greggy@informix.com | {uunet,pyramid}!infmx!greggy	(415) 926-6300

     Parts of this program are based on the work by Larry Campbell of
     DEC, Mike Hickey of University of DC, and by Dan Grayson.

     Some of this documentation is based on text written by Jeffrey
     Spidle of Iowa State University and by Dan Grayson.

     Some of the formatting of this documentation follows the example of
     Sun Microsystems for their UNIX 4.2 Release.

BUGS
     The -n does not always correctly identify the targets which need to
     be made.  It never misses required makes, but sometimes includes
     unrequired makes.  It also incorrectly sets up the $?  macro in
     these circumstances.  This does not happen during full execution.

     MAKE allows spaces as well as TABs to introduce shell command
     lines.

     Target lines cannot use the double colon (::) syntax.

     Once a dependency is made, MAKE assumes that the dependency file is
     present for the remainder of the run.  If a rule subsequently
     removes that file and future targets depend on it's existence,
     unexpected errors may result.

     Sometimes MAKE gets confused when searching for implicit rules, and
     uses several rules instead of a single rule.  For example, the two
     rules .c.o and .l.c may be used, rather than the more direct .l.o
     rule.

     If a number of command line flags are run together, and contains
     either `f' or `d', the whole set of flags is dropped from
     MAKEFLAGS.

     The following flags are NOT supported:

     -p  Print out the compete set of macro definitions and target
         descriptions.

     -P  Report dependencies recursively to show the entire dependency
         hierarchy, without rebuilding any targets.

     The following special targets are NOT supported:

     .KEEP_STATE:
     .MAKE_VERSION:
     .PRECIOUS:
     .SCCS_GET:
