/*
 * decl.h
 *
 * 88-10-01 v1.0	created by greg yachuk, placed in the public domain
 * 88-10-06 v1.1	changed prerequisite list handling
 * 88-11-11 v1.2	fixed some bugs and added environment variables
 * 89-07-12 v1.3	stop appending shell commands, and flush output
 * 89-08-01 v1.4 AB	lots of new options and code
 * 89-10-30 v1.5	-f -S -q options, took some changes from v1.4
 * 90-04-18 v1.6	-b -- -W options, emulate <<, non-BSD cleanup
 */

#ifdef COHERENT
extern int main();
extern int make_args();
extern char **grow_list();
extern FILE *fopenp();
extern int make();
extern int default_rule();
extern char *get_preqname();
extern int add_metas();
extern int split_meta();
extern int touch_file();
extern int display_prereq();
extern long file_time();
extern int usage();
extern int build();
extern char *shellinput();
extern int new_make();
extern int parse();
extern int link_targs();
extern int add_macro();
extern int add_symbol();
extern struct symnode *get_symbol();
extern struct symnode *dup_symbol();
extern struct targnode *add_target();
extern struct targnode *hash_target();
extern struct filenode *add_file();
extern struct filenode *hash_file();
extern char **append_node();
extern struct shellnode *add_shell();
extern char *breakout();
#else
#ifdef	__STDC__
extern int main(int argc, char **argv);
extern int make_args(int argc, char **argv);
extern char **grow_list(char **list, int *len);
extern FILE *fopenp(char *fname, char *type);
extern int make(char *targname, int worry);
extern int default_rule(char *targname, struct targnode * targetp, int worry, int mustbuild);
extern char *get_preqname(struct targnode * targp, char *suffix, char *basename);
extern int add_metas(char *basename, char *preqname, char *targname);
extern int split_meta(char *sym, char *name);
extern int touch_file(char *targname);
extern int display_prereq(char *targname, long targtime, char *preqname, long preqtime);
extern long file_time(char *fname, int built);
extern int usage(void);
extern int build(struct shellnode * *shellp);
extern char *shellinput(struct shellnode * **shellp, char *eof);
extern int new_make(char **argv);
extern int parse(FILE * fd);
extern int link_targs(struct targnode * *targs, struct filenode * *preqs, struct shellnode * *shells);
extern int add_macro(char *input, int scmd);
extern int add_symbol(char *name, char *value, int scmd);
extern struct symnode *get_symbol(char *name, int scmd);
extern struct symnode *dup_symbol(struct symnode * sp, char *svalue);
extern struct targnode *add_target(char *name);
extern struct targnode *hash_target(char *name, unsigned short *maskp);
extern struct filenode *add_file(char *name);
extern struct filenode *hash_file(char *name, unsigned short *maskp);
extern char **append_node(char **node, char **adds, int size);
extern struct shellnode *add_shell(char *input);
extern char *breakout(char *input);
#else
extern int main();
extern int make_args();
extern char **grow_list();
extern FILE *fopenp();
extern int make();
extern int default_rule();
extern char *get_preqname();
extern int add_metas();
extern int split_meta();
extern int touch_file();
extern int display_prereq();
extern long file_time();
extern int usage();
extern int build();
extern char *shellinput();
extern int new_make();
extern int parse();
extern int link_targs();
extern int add_macro();
extern int add_symbol();
extern struct symnode *get_symbol();
extern struct symnode *dup_symbol();
extern struct targnode *add_target();
extern struct targnode *hash_target();
extern struct filenode *add_file();
extern struct filenode *hash_file();
extern char **append_node();
extern struct shellnode *add_shell();
extern char *breakout();
#endif
#endif
