#include <stdio.h>
#include <varargs.h>
#include <stdlib.h>
#include <string.h>

#define vprintf(format,ap)	vfprintf(stdout,format,ap)

int
vfprintf(stream,format,ap)
FILE *stream;
char *format;
va_list ap;
{
	char *format_position=format;
	int argument_counter=0;

	while (strlen(format_position))
	{
		char *current_format_portion,*format_pointer;

		char *next_argument;
	
		int length_of_argument_specifier=strcspn(format_position,"%");
	
		int long_flag=0;

		argument_counter++;

		length_of_argument_specifier+=strcspn(format_position+1+
			length_of_argument_specifier,"%");

#ifdef DEBUG
printf("Length of argument specifer: %d\n",length_of_argument_specifier);
#endif

		if (length_of_argument_specifier)
		{
			current_format_portion=malloc(length_of_argument_specifier);

			if (current_format_portion==NULL)
			{
				fputs("\nvfprintf: malloc error\n",stderr);
				exit(1);
			}

			strncpy(current_format_portion,format_position,
				length_of_argument_specifier);
#ifdef DEBUG
puts(current_format_portion);
#endif
		}
		else
			putc('%',stream);

		format_position+=length_of_argument_specifier;

		format_pointer=strpbrk(current_format_portion,"lLefgdoxucOUXDrs");

		if (format_pointer==NULL)
		{
			fprintf(stream,current_format_portion);
			continue;
		}

#ifdef DEBUG

printf("Format pointer %c\n",*format_pointer);

#endif
		if (*format_pointer=='l'||*format_pointer=='L')
		{
			long_flag++;

			format_pointer++;
		}

		switch(*format_pointer)
		{
#ifdef DOUBLES
		case 'e':
		case 'f':
		case 'g':
			if (long_flag)
			{
		 		next_argument=(double *)va_arg(ap,double); 
				fprintf(stream,current_format_portion,(double)*next_argument); 
			}
			else
			{
		 		next_argument=(float *)va_arg(ap,float);
				fprintf(stream,current_format_portion,(float)*next_argument);
			}
			break;
#endif DOUBLES
		case 'd':
		case 'u':
		case 'o':
		case 'x':
			if (long_flag)
			{ 
				next_argument=va_arg(ap,long);
if(next_argument==NULL)
{
	fputs("\nvprintf va_arg error\n",stderr);
	exit(1);
}
else
	printf("next_argument %X\n",next_argument);

				fprintf(stream,current_format_portion,(long)*next_argument);
			}
			else
			{
				next_argument=va_arg(ap,int);
if(next_argument==NULL)
{
	fputs("\nvprintf va_arg error\n",stderr);
	exit(1);
}
else
	printf("next_argument %X\n",next_argument);
				fprintf(stream,current_format_portion,(int)*next_argument);
			}
			break;
		case 'U':
		case 'O':
		case 'X':
		case 'D':
			next_argument=va_arg(ap,long);
			fprintf(stream,current_format_portion,(long)*next_argument);
			break;
		case 'c':
			next_argument=va_arg(ap,char);
			fprintf(stream,current_format_portion,(char)*next_argument);
			break;
		case 's':
		case 'r':
			next_argument=va_arg(ap,char *);
			fprintf(stream,current_format_portion,(char *)*next_argument);
			break;
		default:
			fputs("\nvfprintf: bad format\n",stderr);
			exit(1);
		}

		free(current_format_portion);
	}

	return argument_counter;
}

int
vsprintf(string,format,ap)
char *string;
char *format;
va_list ap;
{
	char *format_position=format;
	int argument_counter=0;

	while (strlen(format_position))
	{
		char *current_format_portion,*format_pointer;

		char *next_argument;
	
		int length_of_argument_specifier=strcspn(format_position,"%");
	
		int long_flag=0;

		argument_counter++;

		length_of_argument_specifier=strcspn(format_position+1+
			length_of_argument_specifier,"%")+
			length_of_argument_specifier;

		if (length_of_argument_specifier)
		{
			current_format_portion=malloc(length_of_argument_specifier);

			if (current_format_portion==NULL)
			{
				fputs("\nvfprintf: malloc error\n",stderr);
				exit(1);
			}

			strncpy(current_format_portion,format_position,
				length_of_argument_specifier);
		}
		else
			*string++='%';

		format_position+=length_of_argument_specifier;

		format_pointer=strpbrk(current_format_portion,"lLefgdoxucOUXDrs");

		if (format_pointer==NULL)
		{
			sprintf(string,current_format_portion);
			continue;
		}

		if (*format_pointer=='l'||*format_pointer=='L')
		{
			long_flag++;

			format_pointer++;
		}

		switch(*format_pointer)
		{
#ifdef DOUBLES 
		case 'e': 
		case 'f':
		case 'g':
			if (long_flag)
			{
		 		next_argument=(double *)va_arg(ap,double); 
				sprintf(string,current_format_portion,(double)*next_argument); 
			}
			else
			{
		 		next_argument=(float *)va_arg(ap,float);
				sprintf(string,current_format_portion,(float)*next_argument);
			}
			break;
#endif DOUBLES
		case 'd':
		case 'u':
		case 'o':
		case 'x':
			if (long_flag)
			{ 
				next_argument=va_arg(ap,long);
				sprintf(string,current_format_portion,(long)*next_argument);
			}
			else
			{
				next_argument=va_arg(ap,int);
				sprintf(string,current_format_portion,(int)*next_argument);
			}
			break;
		case 'U':
		case 'O':
		case 'X':
		case 'D':
			next_argument=va_arg(ap,long);
			sprintf(string,current_format_portion,(long)*next_argument);
			break;
		case 'c':
			next_argument=va_arg(ap,char);
			sprintf(string,current_format_portion,(char)*next_argument);
			break;
		case 's':
		case 'r':
			next_argument=va_arg(ap,char *);
			sprintf(string,current_format_portion,(char *)*next_argument);
			break;
		default:
			fputs("\nvfprintf: bad format\n",stderr);
			exit(1);
		}

		free(current_format_portion);

		string+=length_of_argument_specifier+1;
	}

	return argument_counter;
}

#ifdef DEBUG

main()
{
	char teststring[81];

	printformat(stdout,"%d %lu %s pirates\n %c%d\n",34,12345667,"Hello",'H',34);

	stringformat(teststring,"  %d  hello %lu %s %c%d\n",34,12345667,"Hello",'H',34);

	puts(teststring);

	puts("Done!");
}

int 
printformat(stream,format,va_alist)
FILE *stream;
char *format;
va_dcl
{
	va_list ap;

	va_start(ap);

	vfprintf(stream,format,ap);

	va_end(ap);

	return(0);
}

int 
stringformat(string,format,va_alist)
char *string;
char *format;
va_dcl
{
	va_list ap;

	va_start(ap);

	vsprintf(string,format,ap);

	va_end(ap);

	return(0);
}
#endif DEBUG
