 

 

 

 

 




 
typedef struct	FILE {
	unsigned char	*_cp,		 
			*_dp,		 
			*_bp;		 
	int	_cc;			 
	int	(*_gt)(),		 
		(*_pt)();		 
	char	_ff;			 
	char	_fd;			 
	int	_uc;			 
}	FILE;

 







 



 




 
extern	FILE	_stdin, _stdout, _stderr, *_fp[60];




 






 
FILE	*_stropen();
FILE	*fdopen();
char	*fgets();
FILE	*fopen();
FILE	*freopen();
long	ftell();
char	*gets();
char	*malloc();
FILE	*popen();
char	*sbrk();
void	setbuf();

 













 

 
 




 
extern	int	isalnum( );	 
extern	int	isalpha( );	 
extern	int	iscntrl( );	 
extern	int	isdigit( );	 
extern	int	isgraph( );	 
extern	int	islower( );	 
extern	int	isprint( );	 
extern	int	ispunct( );	 
extern	int	isspace( );	 
extern	int	isupper( );	 
extern	int	isxdigit( );	 
extern	int	tolower( );	 
extern	int	toupper( );	 

 
extern	int	isascii( );
extern	int	toascii( );
extern	int	_tolower( );
extern	int	_toupper( );

 

extern	unsigned char _ctype[257];	 










 












 







 

 
 




typedef	char *va_list;







 


 


 


 


 


 


 


 

 


 




 









struct _obstack_chunk		 
{
  char  *limit;			 
  struct _obstack_chunk *prev;	 
  char	contents[4];		 
};

struct obstack		 
{
  long	chunk_size;		 
  struct _obstack_chunk* chunk;	 
  char	*object_base;		 
  char	*next_free;		 
  char	*chunk_limit;		 
  int	temp;			 
  int   alignment_mask;		 
  struct _obstack_chunk *(*chunkfun) ();  
  char (*freefun) ();		 
};

 


  extern void _obstack_newchunk ();
  extern void _obstack_free ();
  extern void _obstack_begin ();




 

 



 



 



 


















































 
 






typedef	unsigned int	size_t;		 





 
extern	char	*memchr();		 
extern	int	memcmp();		 
extern	char	*memcpy();		 
extern	char	*memmove();		 
extern	char	*memset();		 
extern	char	*strcat();		 
extern	char	*strchr();		 
extern	int	strcmp();		 
extern	int	strcoll();		 
extern	char	*strcpy();		 
extern	size_t	strcspn();		 
extern	char	*strerror();		 
extern	size_t	strlen();		 
extern	char	*strncat();		 
extern	int	strncmp();		 
extern	char	*strncpy();		 
extern	char	*strpbrk();		 
extern	char	*strrchr();		 
extern	size_t	strspn();		 
extern	char	*strstr();		 
extern	char	*strtok();		 
extern	size_t	strxfrm();		 

 
extern	char	*memccpy();

 
extern	void	_memxchg();







 
 






 







extern  void exit();
extern  void abort();


 
 




 





 
typedef	struct { int quot; int rem; } div_t;	 
typedef	struct { long quot; long rem; } ldiv_t;	 



typedef	char		wchar_t;	 





 
extern	void	abort(		 				);
extern	int	abs(		 				);
extern	double	atof(		 			);
extern	int	atoi(		 			);
extern	long int atol(		 			);
extern	char	*bsearch(	  );
extern	char	*calloc(	 		);
extern	div_t	div(		 		);
extern	void	exit(		 			);
extern	void	free(		 				);
extern	char	*getenv(	 			);
extern	long int labs(		 			);
extern	ldiv_t	ldiv(		 	);
extern	char	*malloc(	 			);
extern	void	qsort(		  );
extern	int	rand(		 				);
extern	char	*realloc(	 		);
extern	void	srand(		 			);
extern	double	strtod(		 	);
extern	long int strtol(	  );
extern	unsigned long strtoul(	  );
extern	int	system(		 		);



 
extern	double		_pow10	   ();



 



extern int pclose();
extern char *mktemp();








typedef enum boolean { false = 0, true = 1 } boolean;

extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];




 
typedef void builtin_func();


 

 
extern int interactive;			 
extern int sync_output;			 
extern int debug_level;			 
extern int hash_table_size;		 
extern int ndivertion;			 
extern int no_gnu_extensions;		 
extern int max_debug_argument_length;	 
extern int suppress_warnings;		 

 
extern void warning();
extern void error();
extern  void fatal();
extern  void internal_error();

 
extern char *xmalloc();
extern char *xrealloc();
extern void xfree();
extern char *xstrdup();


 

 
enum debug_info {
    debug_trace_args = 0x01,		 
    debug_trace_expansion = 0x02,	 
    debug_trace_quote = 0x04,		 
    debug_trace_all = 0x08,		 
    debug_trace_line = 0x10,		 
    debug_trace_file  = 0x20,		 
    debug_trace_path = 0x40,		 
    debug_trace_call = 0x80,		 
    debug_trace_input = 0x100,		 
    debug_trace_callid = 0x200,		 

    debug_trace_verbose = 0x3ff,	 
    debug_trace_default = 0x07,		 
};

extern void debug_init();
extern int debug_decode();
extern boolean debug_set_output();
extern void debug_print();
extern void debug_message();

extern void trace_prepre();
extern void trace_pre();
extern void trace_post();


 

 
enum token_type {
    TOKEN_EOF,				 
    TOKEN_STRING,			 
    TOKEN_WORD,				 
    TOKEN_SIMPLE,			 
    TOKEN_MACDEF,			 
};

 
enum token_data_type {
    TOKEN_VOID,
    TOKEN_TEXT,
    TOKEN_FUNC,
};

struct token_data {
    enum token_data_type type;
    union {
	struct {
	    char *text;
	} u_t;
	struct {
	    builtin_func *func;
	    boolean traced;
	} u_f;
    } u;
};






typedef enum token_type token_type;
typedef enum token_data_type token_data_type;
typedef struct token_data token_data;

extern void input_init();
extern int peek_input();
extern token_type next_token();
extern void skip_line();

 
extern void push_file();
extern void push_macro();

extern void push_string();
extern struct obstack *push_string_init();
extern char *push_string_finish();

extern void push_wrapup();
extern boolean pop_wrapup();

 
extern char *current_file;
extern int current_line;

 
extern char *bcomm, *ecomm;
extern char *lquote, *rquote;
 
extern int len_lquote, len_rquote;






extern void set_quotes();
extern void set_comment();


 
extern int output_lines;
extern int output_current_line;



extern void output_init();
extern void sync_line();
extern void shipout_text();
extern void make_divertion();
extern void insert_divertion();
extern void insert_file();


 

 
enum symbol_lookup {
    SYMBOL_LOOKUP,
    SYMBOL_INSERT,
    SYMBOL_DELETE,
    SYMBOL_PUSHDEF,
    SYMBOL_POPDEF,
};

 
struct symbol {
    struct symbol *next;
    boolean traced;
    boolean shadowed;
    boolean macro_args;

    char *name;
    token_data data;
};










typedef enum symbol_lookup symbol_lookup;
typedef struct symbol symbol;
typedef void hack_symbol();



extern symbol **symtab;

extern void symtab_init();
extern symbol *lookup_symbol();

extern void hack_all_symbols();


 

extern void expand_input();
extern void call_macro();


 

struct builtin {
    char *name;
    boolean gnu_extension;
    boolean groks_macro_args;
    builtin_func *func;
};

struct predefined {
    char *unix_name;
    char *gnu_name;
    char *func;
};

typedef struct builtin builtin;
typedef struct predefined predefined;

extern void builtin_init();
extern void define_user_macro();
extern void undivert_all();
extern void expand_user_macro();

extern builtin *find_builtin_by_addr();


 

extern void include_init();
extern void include_env_init();
extern void add_include_directory();
extern FILE *path_search();


 

extern boolean evaluate();


 

extern void format();


 



 

enum input_type {
    INPUT_FILE,
    INPUT_STRING,
    INPUT_MACRO,
};

typedef enum input_type input_type;

struct input_block {
    struct input_block *prev;		 
    input_type type;			 
    union {
	struct {
	    char *string;		 
	} u_s;
	struct {
	    FILE *file;			 
	    char *name;			 
	    int lineno;			 
	     
	    int out_lineno;		 
	    boolean advance_line;	 
	} u_f;
	struct {
	    builtin_func *func;		 
	    boolean traced;		 
	} u_m;
    } u;
};

typedef struct input_block input_block;


 
char *current_file;

 
int current_line;


 
static struct obstack token_stack;

 
static struct obstack input_stack;

 
static struct obstack wrapup_stack;

 
static struct obstack *current_input;

 
static char *token_buttom;

 
static input_block *isp;

 
static input_block *wsp;

 
static input_block *next;

 
static boolean must_advance_line;




 
char *rquote; 
char *lquote;

 
int len_rquote;
int len_lquote;

 
static char *def_rquote = "\'"; 
static char *def_lquote = "`";

 
char *bcomm;
char *ecomm;

 
static int len_bcomm;
static int len_ecomm;

 
static char *def_bcomm = "#";
static char *def_ecomm = "\n";


 
void 
push_file(fp, title)
    FILE *fp;
    char *title;
{
    input_block *i;

    if (next != 0) {
	( (current_input)->temp = (char *)(next) - (char *) (current_input)->chunk, (((current_input)->temp >= 0 && (current_input)->temp < (current_input)->chunk_limit - (char *) (current_input)->chunk) ? (int) ((current_input)->next_free = (current_input)->object_base = (current_input)->temp + (char *) (current_input)->chunk) : (_obstack_free ((current_input), (current_input)->temp + (char *) (current_input)->chunk), 0)));
	next = 0;
    }

    if (debug_level & debug_trace_input)
	debug_message("input read from %s", title);

    i = (input_block *)(( ((current_input))->temp = ((sizeof(struct input_block))), ((((current_input))->chunk_limit - ((current_input))->next_free < ((current_input))->temp) ? (_obstack_newchunk (((current_input)), ((current_input))->temp), 0) : 0), ((current_input))->next_free += ((current_input))->temp), ( ((current_input))->temp = ((((current_input))->object_base) - (char *)0), ((current_input))->next_free = (((((((current_input))->next_free) - (char *)0)+((current_input))->alignment_mask) & ~ (((current_input))->alignment_mask)) + (char *)0), ((((current_input))->next_free - (char *)((current_input))->chunk > ((current_input))->chunk_limit - (char *)((current_input))->chunk) ? (((current_input))->next_free = ((current_input))->chunk_limit) : 0), ((current_input))->object_base = ((current_input))->next_free, ((((current_input))->temp) + (char *)0)));
    i->type = INPUT_FILE;

    i->u.u_f.name = current_file;
    i->u.u_f.lineno = current_line;
    i->u.u_f.out_lineno = output_current_line;
    i->u.u_f.advance_line = must_advance_line;
    current_file = (( ((current_input))->temp = ((strlen(title))), ((((current_input))->next_free + ((current_input))->temp + 1 > ((current_input))->chunk_limit) ? (_obstack_newchunk (((current_input)), ((current_input))->temp + 1), 0) : 0), memcpy((((current_input))->next_free),((title)),(((current_input))->temp)), ((current_input))->next_free += ((current_input))->temp, *(((current_input))->next_free)++ = 0), ( ((current_input))->temp = ((((current_input))->object_base) - (char *)0), ((current_input))->next_free = (((((((current_input))->next_free) - (char *)0)+((current_input))->alignment_mask) & ~ (((current_input))->alignment_mask)) + (char *)0), ((((current_input))->next_free - (char *)((current_input))->chunk > ((current_input))->chunk_limit - (char *)((current_input))->chunk) ? (((current_input))->next_free = ((current_input))->chunk_limit) : 0), ((current_input))->object_base = ((current_input))->next_free, ((((current_input))->temp) + (char *)0)));
    current_line = 1;

    if (sync_output) {
	output_lines = 0;
	sync_line(1, current_file);
    }

    i->u.u_f.file = fp;
    i->prev = isp;
    isp = i;
}

 
void 
push_macro(func, traced)
    builtin_func *func;
    boolean traced;
{
    input_block *i;

    if (next != 0) {
	( (current_input)->temp = (char *)(next) - (char *) (current_input)->chunk, (((current_input)->temp >= 0 && (current_input)->temp < (current_input)->chunk_limit - (char *) (current_input)->chunk) ? (int) ((current_input)->next_free = (current_input)->object_base = (current_input)->temp + (char *) (current_input)->chunk) : (_obstack_free ((current_input), (current_input)->temp + (char *) (current_input)->chunk), 0)));
	next = 0;
    }

    i = (input_block *)(( ((current_input))->temp = ((sizeof(struct input_block))), ((((current_input))->chunk_limit - ((current_input))->next_free < ((current_input))->temp) ? (_obstack_newchunk (((current_input)), ((current_input))->temp), 0) : 0), ((current_input))->next_free += ((current_input))->temp), ( ((current_input))->temp = ((((current_input))->object_base) - (char *)0), ((current_input))->next_free = (((((((current_input))->next_free) - (char *)0)+((current_input))->alignment_mask) & ~ (((current_input))->alignment_mask)) + (char *)0), ((((current_input))->next_free - (char *)((current_input))->chunk > ((current_input))->chunk_limit - (char *)((current_input))->chunk) ? (((current_input))->next_free = ((current_input))->chunk_limit) : 0), ((current_input))->object_base = ((current_input))->next_free, ((((current_input))->temp) + (char *)0)));
    i->type = INPUT_MACRO;

    i->u.u_m.func = func;
    i->u.u_m.traced = traced;
    i->prev = isp;
    isp = i;
}

 
struct obstack *
push_string_init()
{
    if (next != 0)
	internal_error("recursive push_string!");

    next = (input_block *)(( ((current_input))->temp = ((sizeof(struct input_block))), ((((current_input))->chunk_limit - ((current_input))->next_free < ((current_input))->temp) ? (_obstack_newchunk (((current_input)), ((current_input))->temp), 0) : 0), ((current_input))->next_free += ((current_input))->temp), ( ((current_input))->temp = ((((current_input))->object_base) - (char *)0), ((current_input))->next_free = (((((((current_input))->next_free) - (char *)0)+((current_input))->alignment_mask) & ~ (((current_input))->alignment_mask)) + (char *)0), ((((current_input))->next_free - (char *)((current_input))->chunk > ((current_input))->chunk_limit - (char *)((current_input))->chunk) ? (((current_input))->next_free = ((current_input))->chunk_limit) : 0), ((current_input))->object_base = ((current_input))->next_free, ((((current_input))->temp) + (char *)0)));
    next->type = INPUT_STRING;
    return current_input;
}

 
char *
push_string_finish()
{
    char *ret = 0;

    if (next == 0)
	return 0;

    if ((unsigned) ((current_input)->next_free - (current_input)->object_base) > 0) {
	( (((current_input)->next_free + 1 > (current_input)->chunk_limit) ? (_obstack_newchunk ((current_input), 1), 0) : 0), *((current_input)->next_free)++ = ('\0'));
	next->u.u_s.string = ( (current_input)->temp = (((current_input)->object_base) - (char *)0), (current_input)->next_free = ((((((current_input)->next_free) - (char *)0)+(current_input)->alignment_mask) & ~ ((current_input)->alignment_mask)) + (char *)0), (((current_input)->next_free - (char *)(current_input)->chunk > (current_input)->chunk_limit - (char *)(current_input)->chunk) ? ((current_input)->next_free = (current_input)->chunk_limit) : 0), (current_input)->object_base = (current_input)->next_free, (((current_input)->temp) + (char *)0));
	next->prev = isp;
	isp = next;
	ret = isp->u.u_s.string;	 
    } else
	( (current_input)->temp = (char *)(next) - (char *) (current_input)->chunk, (((current_input)->temp >= 0 && (current_input)->temp < (current_input)->chunk_limit - (char *) (current_input)->chunk) ? (int) ((current_input)->next_free = (current_input)->object_base = (current_input)->temp + (char *) (current_input)->chunk) : (_obstack_free ((current_input), (current_input)->temp + (char *) (current_input)->chunk), 0)));  
    next = 0;
    return ret;
}    

 
void 
push_wrapup(s)
    char *s;
{
    input_block *i = (input_block *)(( ((&wrapup_stack))->temp = ((sizeof(struct input_block))), ((((&wrapup_stack))->chunk_limit - ((&wrapup_stack))->next_free < ((&wrapup_stack))->temp) ? (_obstack_newchunk (((&wrapup_stack)), ((&wrapup_stack))->temp), 0) : 0), ((&wrapup_stack))->next_free += ((&wrapup_stack))->temp), ( ((&wrapup_stack))->temp = ((((&wrapup_stack))->object_base) - (char *)0), ((&wrapup_stack))->next_free = (((((((&wrapup_stack))->next_free) - (char *)0)+((&wrapup_stack))->alignment_mask) & ~ (((&wrapup_stack))->alignment_mask)) + (char *)0), ((((&wrapup_stack))->next_free - (char *)((&wrapup_stack))->chunk > ((&wrapup_stack))->chunk_limit - (char *)((&wrapup_stack))->chunk) ? (((&wrapup_stack))->next_free = ((&wrapup_stack))->chunk_limit) : 0), ((&wrapup_stack))->object_base = ((&wrapup_stack))->next_free, ((((&wrapup_stack))->temp) + (char *)0)));
    i->prev = wsp;
    i->type = INPUT_STRING;
    i->u.u_s.string = (( ((&wrapup_stack))->temp = ((strlen(s))), ((((&wrapup_stack))->next_free + ((&wrapup_stack))->temp + 1 > ((&wrapup_stack))->chunk_limit) ? (_obstack_newchunk (((&wrapup_stack)), ((&wrapup_stack))->temp + 1), 0) : 0), memcpy((((&wrapup_stack))->next_free),((s)),(((&wrapup_stack))->temp)), ((&wrapup_stack))->next_free += ((&wrapup_stack))->temp, *(((&wrapup_stack))->next_free)++ = 0), ( ((&wrapup_stack))->temp = ((((&wrapup_stack))->object_base) - (char *)0), ((&wrapup_stack))->next_free = (((((((&wrapup_stack))->next_free) - (char *)0)+((&wrapup_stack))->alignment_mask) & ~ (((&wrapup_stack))->alignment_mask)) + (char *)0), ((((&wrapup_stack))->next_free - (char *)((&wrapup_stack))->chunk > ((&wrapup_stack))->chunk_limit - (char *)((&wrapup_stack))->chunk) ? (((&wrapup_stack))->next_free = ((&wrapup_stack))->chunk_limit) : 0), ((&wrapup_stack))->object_base = ((&wrapup_stack))->next_free, ((((&wrapup_stack))->temp) + (char *)0)));
    wsp = i;
}



 
static void 
pop_input()
{
    input_block *tmp = isp->prev;

    switch (isp->type) {
    case INPUT_STRING:
    case INPUT_MACRO:
	break;
    case INPUT_FILE:
	if (debug_level & debug_trace_input)
	    debug_message("input reverted to %s, line %d", isp->u.u_f.name, isp->u.u_f.lineno);
	    
	fclose(isp->u.u_f.file);
	current_file = isp->u.u_f.name;
	current_line = isp->u.u_f.lineno;
	output_current_line = isp->u.u_f.out_lineno;
	must_advance_line = isp->u.u_f.advance_line;
	if (sync_output && tmp != 0)
	    sync_line(current_line, current_file);
	break;
    default:
	internal_error("Input stack botch in pop_input()");
	break;
    }
    ( (current_input)->temp = (char *)(isp) - (char *) (current_input)->chunk, (((current_input)->temp >= 0 && (current_input)->temp < (current_input)->chunk_limit - (char *) (current_input)->chunk) ? (int) ((current_input)->next_free = (current_input)->object_base = (current_input)->temp + (char *) (current_input)->chunk) : (_obstack_free ((current_input), (current_input)->temp + (char *) (current_input)->chunk), 0)));
    next = 0; 	 

    isp = tmp;
}

 
boolean 
pop_wrapup()
{
    if (wsp == 0)
	return false;

    current_input = &wrapup_stack;
    isp = wsp;
    wsp = 0;

    return true;
}

 
static void
init_macro_token(td)
    token_data *td;
{
    if (isp->type != INPUT_MACRO)
	internal_error("Bad call to get_macro_func()");

    ((td)->type) = TOKEN_FUNC;
    ((td)->u.u_f.func) = isp->u.u_m.func;
    ((td)->u.u_f.traced) = isp->u.u_m.traced;
}


 
int 
peek_input()
{
    register int ch;

    while (1) {
	if (isp == 0)
	    return 256;

	switch (isp->type) {
	case INPUT_STRING:
	    ch = isp->u.u_s.string[0];
	    if (ch != '\0')
		return ch;
	    break;
	case INPUT_FILE:
	    ch = (++(isp->u.u_f.file)->_cc>0 ? --(isp->u.u_f.file)->_cc,(*(isp->u.u_f.file)->_gt)((isp->u.u_f.file)) : *(isp->u.u_f.file)->_cp++);
	    if (ch != (-1)) {
		ungetc(ch, isp->u.u_f.file);
		return ch;
	    }
	    break;
	case INPUT_MACRO:
	    return 257;
	default:
	    internal_error("Input stack botch in peek_input()");
	    break;
	}
	 
	pop_input();
    }
}

 
static int
next_char()
{
    register int ch;

    if (must_advance_line) {
	must_advance_line = false;
	current_line++;
    }

    while (1) {
	if (isp == 0)
	    return 256;

	switch (isp->type) {
	case INPUT_STRING:
	    ch = *isp->u.u_s.string++;
	    if (ch != '\0')
		return ch;
	    break;
	case INPUT_FILE:
	    ch = (++(isp->u.u_f.file)->_cc>0 ? --(isp->u.u_f.file)->_cc,(*(isp->u.u_f.file)->_gt)((isp->u.u_f.file)) : *(isp->u.u_f.file)->_cp++);
	    if (ch != (-1)) {
		if (ch == '\n') {
		    output_lines = 0;
		    must_advance_line = true;
		}
		return ch;
	    }
	    break;
	case INPUT_MACRO:
	    pop_input();		 
	    return 257;
	    break;
	default:
	    internal_error("Input stack botch in advance_input()");
	    break;
	}
	 
	pop_input();
    }
}

 
void 
skip_line()
{
    int ch;
    
    while ((ch = next_char()) != 256 && ch != '\n')
	;
}


 

int match_input(s)
    char *s;
{
    int n;				 
    int ch;				 
    char *t;

    ch = peek_input();
    if (ch != *s)
	return 0;			 
    (void)next_char();

    if (s[1] == '\0')
	return 1;			 

    for (n = 1, t = s++; (ch = peek_input()) == *s++; n++) {
	(void)next_char();
	if (*s == '\0')			 
	    return 1;
    }

     
    ( (push_string_init())->temp = (n), (((push_string_init())->next_free + (push_string_init())->temp > (push_string_init())->chunk_limit) ? (_obstack_newchunk ((push_string_init()), (push_string_init())->temp), 0) : 0), memcpy(((push_string_init())->next_free),(t),((push_string_init())->temp)), (push_string_init())->next_free += (push_string_init())->temp);
    push_string_finish();
    return 0;
}

 



 
void 
input_init()
{
    current_file = "NONE";
    current_line = 0;

    _obstack_begin ((&token_stack), 0, 0, (void *(*) ()) xmalloc, (char (*) ()) xfree);
    _obstack_begin ((&input_stack), 0, 0, (void *(*) ()) xmalloc, (char (*) ()) xfree);
    _obstack_begin ((&wrapup_stack), 0, 0, (void *(*) ()) xmalloc, (char (*) ()) xfree);

    current_input = &input_stack;

    ( (((&token_stack)->next_free + 1 > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), 1), 0) : 0), *((&token_stack)->next_free)++ = ('\0'));
    token_buttom = ( (&token_stack)->temp = (((&token_stack)->object_base) - (char *)0), (&token_stack)->next_free = ((((((&token_stack)->next_free) - (char *)0)+(&token_stack)->alignment_mask) & ~ ((&token_stack)->alignment_mask)) + (char *)0), (((&token_stack)->next_free - (char *)(&token_stack)->chunk > (&token_stack)->chunk_limit - (char *)(&token_stack)->chunk) ? ((&token_stack)->next_free = (&token_stack)->chunk_limit) : 0), (&token_stack)->object_base = (&token_stack)->next_free, (((&token_stack)->temp) + (char *)0));

    isp = 0;
    wsp = 0;
    next = 0;

    must_advance_line = false;

    set_quotes(0, 0);
    set_comment(0, 0);
}


 

void
set_quotes(lq, rq)
    char *lq;
    char *rq;
{
    if (lquote != def_lquote)
	xfree(lquote);
    if (rquote != def_rquote)
	xfree(rquote);

    lquote = (lq == 0) ? def_lquote : xstrdup(lq);
    rquote = (rq == 0) ? def_rquote : xstrdup(rq);

    len_lquote = strlen(lquote);
    len_rquote = strlen(rquote);
}

void
set_comment(bc, ec)
    char *bc;
    char *ec;
{
    if (bcomm != def_bcomm)
	xfree(bcomm);
    if (ecomm != def_ecomm)
	xfree(ecomm);

    bcomm = (bc == 0) ? def_bcomm : xstrdup(bc);
    ecomm = (ec == 0) ? def_ecomm : xstrdup(ec);

    len_bcomm = strlen(bcomm);
    len_ecomm = strlen(ecomm);
}


 

token_type 
next_token(td)
    token_data *td;
{
    int ch;
    int quote_level;
    token_type type;

    ( (&token_stack)->temp = (char *)(token_buttom) - (char *) (&token_stack)->chunk, (((&token_stack)->temp >= 0 && (&token_stack)->temp < (&token_stack)->chunk_limit - (char *) (&token_stack)->chunk) ? (int) ((&token_stack)->next_free = (&token_stack)->object_base = (&token_stack)->temp + (char *) (&token_stack)->chunk) : (_obstack_free ((&token_stack), (&token_stack)->temp + (char *) (&token_stack)->chunk), 0)));

    ch = peek_input();
    if (ch == 256) {
	return TOKEN_EOF;

    }
    if (ch == 257) {
	init_macro_token(td);
	(void)next_char();
	return TOKEN_MACDEF;
    }

    (void)next_char();
    if (((bcomm)[0] == (ch) && (ch) != '\0' && ((bcomm)[1] == '\0' || (match_input((bcomm)+1) ? (ch) = peek_input(), 1 : 0)))) {

	( (&token_stack)->temp = (len_bcomm), (((&token_stack)->next_free + (&token_stack)->temp > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), (&token_stack)->temp), 0) : 0), memcpy(((&token_stack)->next_free),(bcomm),((&token_stack)->temp)), (&token_stack)->next_free += (&token_stack)->temp);
	while ((ch = next_char()) != 256 && !((ecomm)[0] == (ch) && (ch) != '\0' && ((ecomm)[1] == '\0' || (match_input((ecomm)+1) ? (ch) = peek_input(), 1 : 0))))
	    ( (((&token_stack)->next_free + 1 > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), 1), 0) : 0), *((&token_stack)->next_free)++ = (ch));
	if (ch != 256)
	    ( (&token_stack)->temp = (len_ecomm), (((&token_stack)->next_free + (&token_stack)->temp > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), (&token_stack)->temp), 0) : 0), memcpy(((&token_stack)->next_free),(ecomm),((&token_stack)->temp)), (&token_stack)->next_free += (&token_stack)->temp);
	type = TOKEN_STRING;

    } else if ((_ctype[(ch)+1]&(0x01|0x02)) || ch == '_') {

	( (((&token_stack)->next_free + 1 > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), 1), 0) : 0), *((&token_stack)->next_free)++ = (ch));
	while ((ch = peek_input()) != 256 && ((_ctype[(ch)+1]&((0x01|0x02)|0x04)) || ch == '_')) {
	    ( (((&token_stack)->next_free + 1 > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), 1), 0) : 0), *((&token_stack)->next_free)++ = (ch));
	    (void)next_char();
	}
	type = TOKEN_WORD;

    } else if (!((lquote)[0] == (ch) && (ch) != '\0' && ((lquote)[1] == '\0' || (match_input((lquote)+1) ? (ch) = peek_input(), 1 : 0)))) {

	type = TOKEN_SIMPLE;
	( (((&token_stack)->next_free + 1 > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), 1), 0) : 0), *((&token_stack)->next_free)++ = (ch));

    } else {

	quote_level = 1;
	while (1) {
	    ch = next_char();
	    if (ch == 256)
		fatal("EOF in string");

	    if (((rquote)[0] == (ch) && (ch) != '\0' && ((rquote)[1] == '\0' || (match_input((rquote)+1) ? (ch) = peek_input(), 1 : 0)))) {
		if (--quote_level == 0)
		    break;
		( (&token_stack)->temp = (len_rquote), (((&token_stack)->next_free + (&token_stack)->temp > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), (&token_stack)->temp), 0) : 0), memcpy(((&token_stack)->next_free),(rquote),((&token_stack)->temp)), (&token_stack)->next_free += (&token_stack)->temp);
	    } else if (((lquote)[0] == (ch) && (ch) != '\0' && ((lquote)[1] == '\0' || (match_input((lquote)+1) ? (ch) = peek_input(), 1 : 0)))) {
		quote_level++;
		( (&token_stack)->temp = (len_lquote), (((&token_stack)->next_free + (&token_stack)->temp > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), (&token_stack)->temp), 0) : 0), memcpy(((&token_stack)->next_free),(lquote),((&token_stack)->temp)), (&token_stack)->next_free += (&token_stack)->temp);
	    } else
		( (((&token_stack)->next_free + 1 > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), 1), 0) : 0), *((&token_stack)->next_free)++ = (ch));
	}
	type = TOKEN_STRING;
    }

    ( (((&token_stack)->next_free + 1 > (&token_stack)->chunk_limit) ? (_obstack_newchunk ((&token_stack), 1), 0) : 0), *((&token_stack)->next_free)++ = ('\0'));

    ((td)->type) = TOKEN_TEXT;
    ((td)->u.u_t.text) = ( (&token_stack)->temp = (((&token_stack)->object_base) - (char *)0), (&token_stack)->next_free = ((((((&token_stack)->next_free) - (char *)0)+(&token_stack)->alignment_mask) & ~ ((&token_stack)->alignment_mask)) + (char *)0), (((&token_stack)->next_free - (char *)(&token_stack)->chunk > (&token_stack)->chunk_limit - (char *)(&token_stack)->chunk) ? ((&token_stack)->next_free = (&token_stack)->chunk_limit) : 0), (&token_stack)->object_base = (&token_stack)->next_free, (((&token_stack)->temp) + (char *)0));

    return type;
}



